<?php

// line 11 "src/Parser/TemplateParser.y"


namespace Smarty\Parser;

use \Smarty\Lexer\TemplateLexer as Lexer;
use \Smarty\ParseTree\Template as TemplateParseTree;
use \Smarty\Compiler\Template as TemplateCompiler;
use \Smarty\ParseTree\Code;
use \Smarty\ParseTree\Dq;
use \Smarty\ParseTree\DqContent;
use \Smarty\ParseTree\Tag;
use \Smarty\CompilerException;

/**
* Smarty Template Parser Class
*
* This is the template parser.
* It is generated from the TemplateParser.y file
* 
* @author Uwe Tews <uwe.tews@googlemail.com>
*/
class TemplateParser
{
// line 35 "src/Parser/TemplateParser.y"

    const ERR1 = 'Security error: Call to private object member not allowed';
    const ERR2 = 'Security error: Call to dynamic object member not allowed';

    /**
     * result status
     *
     * @var bool
     */
    public $successful = true;

    /**
     * return value
     *
     * @var mixed
     */
    public $retvalue = 0;

    /**
     * @var
     */
    public $yymajor;

    /**
     * last index of array variable
     *
     * @var mixed
     */
    public $last_index;

    /**
     * last variable name
     *
     * @var string
     */
    public $last_variable;

    /**
     * root parse tree buffer
     *
     * @var TemplateParseTree
     */
    public $root_buffer;

    /**
     * current parse tree object
     *
     * @var \Smarty\ParseTree\Base
     */
    public $current_buffer;

    /**
     * lexer object
     *
     * @var Lexer
     */
    public $lex;

    /**
     * internal error flag
     *
     * @var bool
     */
    private $internalError = false;

    /**
     * {strip} status
     *
     * @var bool
     */
    public $strip = false;
    /**
     * compiler object
     *
     * @var TemplateCompiler
     */
    public $compiler = null;

    /**
     * smarty object
     *
     * @var \Smarty\Smarty
     */
    public $smarty = null;

    /**
     * template object
     *
     * @var \Smarty\Template
     */
    public $template = null;

    /**
     * block nesting level
     *
     * @var int
     */
    public $block_nesting_level = 0;

    /**
     * security object
     *
     * @var \Smarty\Security
     */
    public $security = null;

    /**
     * template prefix array
     *
     * @var \Smarty\ParseTree\Base[]
     */
    public $template_prefix = array();

    /**
     * template prefix array
     *
     * @var \Smarty\ParseTree\Base[]
     */
    public $template_postfix = array();

    /**
     * constructor
     *
     * @param Lexer        $lex
     * @param TemplateCompiler $compiler
     */
    public function __construct(Lexer $lex, TemplateCompiler $compiler)
    {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->template = $this->compiler->getTemplate();
        $this->smarty = $this->template->getSmarty();
        $this->security = $this->smarty->security_policy ?? false;
        $this->current_buffer = $this->root_buffer = new TemplateParseTree();
    }

     /**
     * insert PHP code in current buffer
     *
     * @param string $code
     */
    public function insertPhpCode($code)
    {
        $this->current_buffer->append_subtree($this, new Tag($this, $code));
    }

    /**
     * error rundown
     *
     */
    public function errorRunDown()
    {
        while ($this->yystack !== array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource($this->yyTraceFILE)) {
            fclose($this->yyTraceFILE);
        }
    }

    /**
     *  merge PHP code with prefix code and return parse tree tag object
     *
     * @param string $code
     *
     * @return Tag
     */
    private function mergePrefixCode($code)
    {
        $tmp = '';
        foreach ($this->compiler->prefix_code as $preCode) {
            $tmp .= $preCode;
        }
        $this->compiler->prefix_code = array();
        $tmp .= $code;
        return new Tag($this, $this->compiler->processNocacheCode($tmp));
    }


    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_TEXT                           =  3;
    const TP_STRIPON                        =  4;
    const TP_STRIPOFF                       =  5;
    const TP_LITERALSTART                   =  6;
    const TP_LITERALEND                     =  7;
    const TP_LITERAL                        =  8;
    const TP_SIMPELOUTPUT                   =  9;
    const TP_SIMPLETAG                      = 10;
    const TP_SMARTYBLOCKCHILDPARENT         = 11;
    const TP_LDEL                           = 12;
    const TP_RDEL                           = 13;
    const TP_DOLLARID                       = 14;
    const TP_EQUAL                          = 15;
    const TP_ID                             = 16;
    const TP_PTR                            = 17;
    const TP_LDELIF                         = 18;
    const TP_LDELFOR                        = 19;
    const TP_SEMICOLON                      = 20;
    const TP_INCDEC                         = 21;
    const TP_TO                             = 22;
    const TP_STEP                           = 23;
    const TP_LDELFOREACH                    = 24;
    const TP_SPACE                          = 25;
    const TP_AS                             = 26;
    const TP_APTR                           = 27;
    const TP_LDELSETFILTER                  = 28;
    const TP_CLOSETAG                       = 29;
    const TP_LDELSLASH                      = 30;
    const TP_ATTR                           = 31;
    const TP_INTEGER                        = 32;
    const TP_COMMA                          = 33;
    const TP_OPENP                          = 34;
    const TP_CLOSEP                         = 35;
    const TP_MATH                           = 36;
    const TP_UNIMATH                        = 37;
    const TP_ISIN                           = 38;
    const TP_QMARK                          = 39;
    const TP_NOT                            = 40;
    const TP_TYPECAST                       = 41;
    const TP_HEX                            = 42;
    const TP_DOT                            = 43;
    const TP_INSTANCEOF                     = 44;
    const TP_SINGLEQUOTESTRING              = 45;
    const TP_DOUBLECOLON                    = 46;
    const TP_NAMESPACE                      = 47;
    const TP_AT                             = 48;
    const TP_HATCH                          = 49;
    const TP_OPENB                          = 50;
    const TP_CLOSEB                         = 51;
    const TP_DOLLAR                         = 52;
    const TP_LOGOP                          = 53;
    const TP_SLOGOP                         = 54;
    const TP_TLOGOP                         = 55;
    const TP_SINGLECOND                     = 56;
    const TP_ARRAYOPEN                      = 57;
    const TP_QUOTE                          = 58;
    const TP_BACKTICK                       = 59;
    const YY_NO_ACTION = 541;
    const YY_ACCEPT_ACTION = 540;
    const YY_ERROR_ACTION = 539;

    const YY_SZ_ACTTAB = 2565;
public static $yy_action = array(
     33,  106,  269,  306,  179,  305,  200,  247,  248,  249,
      1,  264,  138,  237,  202,  361,    6,   87,  284,  222,
    338,  361,  112,  107,  400,  321,  217,  261,  218,  130,
    224,  400,   21,  400,   49,   44,  400,   32,   45,   46,
    278,  226,  400,  282,  400,  203,  400,   53,    4,  139,
    302,  231,   28,  102,  225,    5,   54,  247,  248,  249,
      1,   20,  135,  192,  193,  271,    6,   87,  246,  222,
    216,   29,  112,  229,    7,  159,  217,  261,  218,  140,
    208,  272,   21,  509,   53,   44,   13,  302,   45,   46,
    278,  226,  149,  235,  153,  203,  257,   53,    4,  328,
    302,  302,  256,  304,  143,    5,   54,  247,  248,  249,
      1,  302,  100,  394,   86,  236,    6,   87,    3,  222,
    102,  257,  112,  144,   97,  394,  217,  261,  218,  102,
    224,  394,   21,  256,  446,   44,  178,  305,   45,   46,
    278,  226,  302,  282,  200,  203,  446,   53,    4,  115,
    302,   47,   22,  285,   41,    5,   54,  247,  248,  249,
      1,  139,  137,  267,  202,  141,    6,   87,   14,  222,
    540,   99,  112,  151,   15,  446,  217,  261,  218,  314,
    224,  216,   21,  256,  233,   44,    9,  446,   45,   46,
    278,  226,  325,  282,  268,  203,   53,   53,    4,  302,
    302,  152,  257,  361,  320,    5,   54,  247,  248,  249,
      1,  264,  137,  102,  194,  361,    6,   87,   37,  222,
    102,  361,  112,  257,   89,  316,  217,  261,  218,  314,
    224,  216,   21,   36,   49,   44,  200,   40,   45,   46,
    278,  226,  115,  282,  237,  203,   14,   53,    4,  115,
    302,  238,   15,  155,  107,    5,   54,  247,  248,  249,
      1,  466,  136,  256,  202,  200,    6,   87,  466,  222,
    255,  171,  112,  264,  446,  310,  217,  261,  218,  158,
    224,  257,   11,  142,  157,   44,  446,  183,   45,   46,
    278,  226,   26,  282,  256,  203,   49,   53,    4,  446,
    302,  184,  260,  323,  176,    5,   54,  247,  248,  249,
      1,  446,  137,  264,  189,  291,    6,   87,  183,  222,
    200,  302,  112,  253,  178,  305,  217,  261,  218,  263,
    213,   18,   21,  200,  184,   44,   49,   15,   45,   46,
    278,  226,  146,  282,  269,  203,   25,   53,    4,  220,
    302,  312,  107,  152,  290,    5,   54,  247,  248,  249,
      1,  219,  137,  147,  187,  130,    6,   87,  259,  222,
     16,   19,  112,  256,  167,  258,  217,  261,  218,  111,
    224,  173,   21,   96,  256,   44,  200,   23,   45,   46,
    278,  226,  177,  282,  227,  203,  335,   53,    4,  174,
    302,  180,  305,  170,   90,    5,   54,  247,  248,  249,
      1,  184,  137,  256,  202,   91,    6,   87,  482,  222,
    160,  482,  112,  214,  197,  482,  217,  261,  218,  184,
    188,  181,   21,  245,  302,   44,  164,  140,   45,   46,
    278,  226,  466,  282,   13,  203,  166,   53,    4,  466,
    302,   42,   43,  286,   12,    5,   54,  247,  248,  249,
      1,  264,  139,  447,  202,   40,    6,   87,  293,  294,
    295,  296,  112,   17,  311,  447,  217,  261,  218,  337,
    224,  183,   21,  260,   49,   48,  244,  245,   45,   46,
    278,  226,   24,  282,  303,  203,    8,   53,    4,   92,
    302,   42,   43,  286,   12,    5,   54,  247,  248,  249,
      1,   10,  139,    9,  202,  317,    6,   87,  293,  294,
    295,  296,  112,  116,  299,   35,  217,  261,  218,  225,
    224,  198,   21,   98,   34,   44,  329,  324,   45,   46,
    278,  226,  448,  282,  448,  203,  161,   53,    4,  172,
    302,  129,  175,  225,  232,    5,   54,  288,  215,  216,
    252,  101,   93,  109,  243,  191,  103,   85,  450,  162,
    450,   24,  101,  330,  182,  273,  274,  300,  298,  301,
    250,  251,  281,  204,  283,  113,  289,  262,  300,  298,
    301,  121,  288,  215,  216,  252,  270,   93,  109,  275,
    190,  103,   60,  277,  279,  225,  237,  101,  280,  297,
    273,  274,  129,  239,  199,  266,  107,  281,  204,  283,
      7,  289,  101,  300,  298,  301,  288,   88,  216,  254,
    163,  114,  109,  265,  191,  103,   85,  200,  300,  298,
    301,  101,  200,  259,  273,  274,   19,  165,  326,  362,
    258,  281,  204,  283,  396,  289,  234,  300,  298,  301,
    288,  362,  216,  327,  200,  114,  396,  362,  201,  119,
     72,  336,  396,   37,  259,  101,  393,   19,  273,  274,
    154,  258,  228,  339,   94,  281,  204,  283,  393,  289,
    256,  300,  298,  301,  393,   38,  313,  288,  313,  216,
    313,  313,  114,  207,  319,  201,  119,   72,  313,  313,
    313,  313,  101,  221,  184,  273,  274,  156,  313,  313,
    313,   95,  281,  204,  283,  313,  289,  256,  300,  298,
    301,  313,  313,  313,  288,  313,  216,  313,  313,  108,
    206,  319,  201,  122,   51,  313,  120,  313,  313,  101,
    313,  184,  273,  274,  313,  313,  313,  313,  313,  281,
    204,  283,  313,  289,  313,  300,  298,  301,  288,  313,
    216,  313,  313,  114,  313,  313,  201,  122,   67,  313,
    313,  313,  313,  101,  313,  313,  273,  274,  313,  313,
    313,  313,  313,  281,  204,  283,  313,  289,  313,  300,
    298,  301,  288,  313,  216,  313,  313,  114,  212,  313,
    201,  122,   67,  313,  313,  313,  313,  101,  313,  313,
    273,  274,  313,  313,  313,  313,  313,  281,  204,  283,
    313,  289,  313,  300,  298,  301,  288,  313,  216,  313,
    313,  114,  205,  313,  201,  119,   72,  313,  313,  313,
    313,  101,  313,  313,  273,  274,  313,  313,  313,  313,
    313,  281,  204,  283,  313,  289,  313,  300,  298,  301,
    313,  313,  313,  288,  313,  216,  313,  313,  114,  313,
    318,  201,  122,   78,  313,  313,  313,  313,  101,  313,
    482,  273,  274,  482,  313,  313,  313,  482,  281,  204,
    283,  313,  289,  209,  211,  298,  301,  288,  313,  216,
    313,  313,  108,  313,  313,  201,  122,   58,  313,  238,
    313,  313,  101,  313,  313,  273,  274,  313,  313,  482,
    313,  313,  281,  204,  283,  313,  289,  313,  300,  298,
    301,  288,  313,  216,  313,  313,  114,  313,  313,  201,
    118,   64,  313,  313,  313,  313,  101,  313,  313,  273,
    274,  313,  313,  313,  313,  313,  281,  204,  283,  313,
    289,  313,  300,  298,  301,  288,  313,  216,  313,  313,
    114,  313,  313,  196,  117,   59,  313,  313,  313,  313,
    101,  313,  313,  273,  274,  313,  313,  313,  313,  313,
    281,  204,  283,  313,  289,  313,  300,  298,  301,  288,
    313,  216,  313,  313,  114,  313,  313,  201,  104,   84,
    313,  313,  313,  313,  101,  313,  313,  273,  274,  313,
    313,  313,  313,  313,  281,  204,  283,  313,  289,  313,
    300,  298,  301,  288,  313,  216,  313,  313,  114,  313,
    313,  201,  105,   83,  313,  313,  313,  313,  101,  313,
    313,  273,  274,  313,  313,  313,  313,  313,  281,  204,
    283,  313,  289,  313,  300,  298,  301,  288,  313,  216,
    313,  313,  114,  313,  313,  201,  122,   55,  313,  313,
    313,  313,  101,  313,  313,  273,  274,  313,  313,  313,
    313,  313,  281,  204,  283,  313,  289,  313,  300,  298,
    301,  288,  313,  216,  313,  313,  114,  313,  313,  201,
    122,   66,  313,  313,  313,  313,  101,  313,  313,  273,
    274,  313,  313,  313,  313,  313,  281,  204,  283,  313,
    289,  313,  300,  298,  301,  288,  313,  216,  313,  313,
    114,  313,  313,  201,  104,   56,  313,  313,  313,  313,
    101,  313,  313,  273,  274,  313,  313,  313,  313,  313,
    281,  204,  283,  313,  289,  313,  300,  298,  301,  288,
    313,  216,  313,  313,  114,  313,  313,  201,  122,   65,
    313,  313,  313,  313,  101,  313,  313,  273,  274,  313,
    313,  313,  313,  313,  281,  204,  283,  313,  289,  313,
    300,  298,  301,  288,  313,  216,  313,  313,  114,  313,
    313,  201,  122,   57,  313,  313,  313,  313,  101,  313,
    313,  273,  274,  313,  313,  313,  313,  313,  281,  204,
    283,  313,  289,  313,  300,  298,  301,  288,  313,  216,
    313,  313,  114,  313,  313,  201,  122,   58,  313,  313,
    313,  313,  101,  313,  313,  273,  274,  313,  313,  313,
    313,  313,  281,  204,  283,  313,  289,  313,  300,  298,
    301,  288,  313,  216,  313,  313,  114,  313,  313,  201,
    122,   68,  313,  313,  313,  313,  101,  313,  313,  273,
    274,  313,  313,  313,  313,  313,  281,  204,  283,  313,
    289,  313,  300,  298,  301,  288,  313,  216,  313,  313,
    114,  313,  313,  201,  122,   69,  313,  313,  313,  313,
    101,  313,  313,  273,  274,  313,  313,  313,  313,  313,
    281,  204,  283,  313,  289,  313,  300,  298,  301,  288,
    313,  216,  313,  313,  114,  313,  313,  201,  122,   70,
    313,  313,  313,  313,  101,  313,  313,  273,  274,  313,
    313,  313,  313,  313,  281,  204,  283,  313,  289,  313,
    300,  298,  301,  288,  313,  216,  313,  313,  114,  313,
    313,  201,  122,   71,  313,  313,  313,  313,  101,  313,
    313,  273,  274,  313,  313,  313,  313,  313,  281,  204,
    283,  313,  289,  313,  300,  298,  301,  288,  313,  216,
    313,  313,  114,  313,  313,  201,  122,   73,  313,  313,
    313,  313,  101,  313,  313,  273,  274,  313,  313,  313,
    313,  313,  281,  204,  283,  313,  289,  313,  300,  298,
    301,  288,  313,  216,  313,  313,  114,  313,  313,  195,
    122,   61,  313,  313,  313,  313,  101,  313,  313,  273,
    274,  313,  313,  313,  313,  313,  281,  204,  283,  313,
    289,  313,  300,  298,  301,  288,  313,  216,  313,  313,
    114,  313,  313,  201,  122,   62,  313,  313,  313,  313,
    101,  313,  313,  273,  274,  313,  313,  313,  313,  313,
    281,  204,  283,  313,  289,  313,  300,  298,  301,  288,
    313,  216,  313,  313,  114,  313,  313,  201,  122,   63,
    313,  313,  313,  313,  101,  313,  313,  273,  274,  313,
    313,  313,  313,  313,  281,  204,  283,  313,  289,  313,
    300,  298,  301,  288,  313,  216,  313,  313,  114,  313,
    313,  201,  122,   74,  313,  313,  313,  313,  101,  313,
    313,  273,  274,  313,  313,  313,  313,  313,  281,  204,
    283,  313,  289,  313,  300,  298,  301,  288,  313,  216,
    313,  313,  114,  313,  313,  201,  122,   75,  313,  313,
    313,  313,  101,  313,  313,  273,  274,  313,  313,  313,
    313,  313,  281,  204,  283,  313,  289,  313,  300,  298,
    301,  288,  313,  216,  313,  313,  114,  313,  313,  201,
    122,   76,  313,  313,  313,  313,  101,  313,  313,  273,
    274,  313,  313,  313,  313,  313,  281,  204,  283,  313,
    289,  313,  300,  298,  301,  288,  313,  216,  313,  313,
    114,  313,  313,  201,  122,   77,  313,  313,  313,  313,
    101,  313,  313,  273,  274,  313,  313,  313,  313,  313,
    281,  204,  283,  313,  289,  313,  300,  298,  301,  288,
    313,  216,  313,  313,  114,  313,  313,  201,  122,   79,
    313,  313,  313,  313,  101,  313,  313,  273,  274,  313,
    313,  313,  313,  313,  281,  204,  283,  313,  289,  313,
    210,  298,  301,  288,  313,  216,  313,  313,  114,  313,
    313,  201,  122,   80,  313,  313,  313,  313,  101,  313,
    313,  273,  274,  313,  313,  313,  313,  313,  281,  204,
    283,  313,  289,  313,  300,  298,  301,  288,  313,  216,
    313,  313,  114,  313,  313,  201,  122,   81,  313,  313,
    313,  313,  101,  313,  313,  273,  274,  313,  313,  313,
    313,  313,  281,  204,  283,  313,  289,  313,  300,  298,
    301,  288,  313,  216,  313,  313,  114,  313,  313,  201,
    122,   82,  313,  313,  313,  313,  101,  313,  313,  273,
    274,  313,  313,  313,  313,  313,  281,  204,  283,  313,
    289,  313,  300,  298,  301,  288,  313,  216,  313,  313,
    114,  313,  313,  201,  122,   50,  313,  313,  313,  313,
    101,  313,  313,  273,  274,  313,  313,  313,  313,  313,
    281,  204,  283,  313,  289,  313,  300,  298,  301,  288,
    313,  216,  313,  313,  114,  313,  313,  201,  122,   52,
    313,  313,  313,  313,  101,  313,  313,  273,  274,  313,
    313,  313,  313,  313,  281,  204,  283,  313,  289,  313,
    300,  298,  301,  288,  313,  216,  168,  313,  114,  313,
    313,  201,  134,  313,  313,  313,  256,  313,  101,   47,
     22,  285,   41,  313,  313,  313,  313,  333,  281,  204,
    283,  313,  289,  313,  300,  298,  301,  288,  313,  216,
    145,  313,  114,  313,  313,  201,  128,  313,  313,  313,
    256,  313,  101,   47,   22,  285,   41,  313,  313,  313,
    313,  287,  281,  204,  283,  315,  289,  313,  300,  298,
    301,  247,  248,  249,    2,  313,  313,  313,  313,  313,
      6,   87,  259,  313,  313,   19,  112,  313,   14,  258,
    217,  261,  218,  313,   15,   39,  313,   14,   14,   42,
     43,  286,   12,   15,   15,  313,  313,  313,   42,   43,
    286,   12,  313,  313,  313,  313,  293,  294,  295,  296,
    308,   27,  313,  313,  315,  293,  294,  295,  296,  313,
    247,  248,  249,    2,  313,  313,  313,  110,  313,    6,
     87,  313,  313,  313,  313,  112,  313,  313,  148,  217,
    261,  218,  313,   42,   43,  286,   12,  313,   42,   43,
    286,   12,  313,  313,  313,  313,  313,  313,  313,  313,
    293,  294,  295,  296,  313,  293,  294,  295,  296,  309,
     27,  313,  313,  240,  241,  242,  133,  223,  313,  247,
    248,  249,    1,  313,  482,  313,  313,  482,    6,   87,
      3,  482,  466,  313,  112,  313,  276,  313,  217,  261,
    218,  288,  313,  216,  313,  313,  114,  313,  313,  201,
    132,  313,  313,  313,  313,  313,  101,  313,  466,  313,
    313,  466,  313,  482,  313,  466,  281,  204,  283,  313,
    289,  313,  300,  298,  301,  313,  288,  313,  216,  313,
    200,  114,  313,  313,  201,  123,  313,  313,  313,  313,
    313,  101,  365,  313,  313,  313,  230,  313,  313,  313,
    313,  281,  204,  283,   14,  289,  313,  300,  298,  301,
     15,  313,  288,  446,  216,  313,  169,  114,  313,  313,
    201,  124,  313,  313,  313,  446,  256,  101,  313,   47,
     22,  285,   41,  313,  313,  313,  313,  281,  204,  283,
    313,  289,  313,  300,  298,  301,  313,  288,  313,  216,
    313,  313,  114,  313,  313,  201,  125,  313,  313,  313,
    313,  313,  101,  313,  313,  313,  313,  313,  313,  313,
    313,  313,  281,  204,  283,  313,  289,  313,  300,  298,
    301,  313,  313,  288,  313,  216,  313,  313,  114,  313,
    313,  201,  126,  313,  313,  313,  313,  313,  101,  313,
    313,  313,  313,  313,  313,  313,  313,  313,  281,  204,
    283,  313,  289,  313,  300,  298,  301,  313,  288,  313,
    216,  313,  313,  114,  313,  313,  201,  127,  313,  313,
    313,  313,  313,  101,  313,  313,  313,  313,  313,  313,
    313,  313,  313,  281,  204,  283,  313,  289,  313,  300,
    298,  301,  313,  313,  288,  313,  216,  223,  313,  114,
    313,  313,  201,  131,  482,  313,  313,  482,  313,  101,
    313,  482,  466,  313,  313,  313,  276,  313,  313,  281,
    204,  283,  313,  289,  313,  300,  298,  301,  313,  313,
    409,  313,  313,  313,  313,  313,  313,  313,  466,  313,
    313,  466,  313,  482,  223,  466,  292,  313,  313,  313,
    313,  482,  313,  313,  482,  313,  313,   36,  482,  466,
    313,  223,  446,  276,  409,  409,  409,  409,  482,  313,
    313,  482,  313,  313,  446,  482,  466,  313,  313,   30,
    276,  409,  409,  409,  409,  466,  482,  313,  466,  482,
    482,  313,  466,  482,  466,  313,  313,  313,  276,  313,
    313,  313,  466,  313,  313,  466,  332,  482,  313,  466,
    313,  313,  313,  313,  313,  331,   42,   43,  286,   12,
    466,  313,  313,  466,  313,  482,  313,  466,  313,   42,
     43,  286,   12,  293,  294,  295,  296,  307,  313,   42,
     43,  286,   12,  185,  313,  313,  293,  294,  295,  296,
    186,  313,  313,  313,  322,  313,  293,  294,  295,  296,
     42,   43,  286,   12,   31,  313,   42,   43,  286,   12,
    313,  334,  313,   42,   43,  286,   12,  293,  294,  295,
    296,  313,  313,  293,  294,  295,  296,  313,  313,  313,
    293,  294,  295,  296,   42,   43,  286,   12,   42,   43,
    286,   12,  482,  313,  313,  482,  313,  313,  313,  482,
    466,  293,  294,  295,  296,  293,  294,  295,  296,  313,
    313,  313,  259,  313,  313,   19,  313,  313,  313,  258,
    313,  313,  313,  313,  313,  313,  466,  313,   14,  466,
    150,  482,  313,  466,   15,
    );
    public static $yy_lookahead = array(
      2,   80,  100,   13,  102,  103,    1,    9,   10,   11,
     12,   21,   14,   70,   16,   25,   18,   19,   93,   21,
     77,   31,   24,   80,   13,  104,   28,   29,   30,  104,
     32,   20,   34,   22,   44,   37,   25,   39,   40,   41,
     42,   43,   31,   45,   33,   47,   35,   49,   50,   14,
     52,   16,   12,   17,   43,   57,   58,    9,   10,   11,
     12,   12,   14,   14,   16,   16,   18,   19,   65,   21,
     67,   12,   24,   14,   34,   16,   28,   29,   30,   43,
     32,   32,   34,    1,   49,   37,   50,   52,   40,   41,
     42,   43,   72,   45,   99,   47,  101,   49,   50,   51,
     52,   52,   82,   69,   14,   57,   58,    9,   10,   11,
     12,   52,   14,   13,   16,   15,   18,   19,   15,   21,
     17,  101,   24,   72,   34,   25,   28,   29,   30,   17,
     32,   31,   34,   82,   34,   37,  102,  103,   40,   41,
     42,   43,   52,   45,    1,   47,   46,   49,   50,   46,
     52,   85,   86,   87,   88,   57,   58,    9,   10,   11,
     12,   14,   14,   16,   16,   80,   18,   19,   25,   21,
     61,   62,   24,   72,   31,   34,   28,   29,   30,   65,
     32,   67,   34,   82,   43,   37,   33,   46,   40,   41,
     42,   43,   51,   45,   47,   47,   49,   49,   50,   52,
     52,   99,  101,   13,   51,   57,   58,    9,   10,   11,
     12,   21,   14,   17,   16,   25,   18,   19,   15,   21,
     17,   31,   24,  101,  110,  111,   28,   29,   30,   65,
     32,   67,   34,   15,   44,   37,    1,    2,   40,   41,
     42,   43,   46,   45,   70,   47,   25,   49,   50,   46,
     52,   77,   31,   72,   80,   57,   58,    9,   10,   11,
     12,   43,   14,   82,   16,    1,   18,   19,   50,   21,
     82,   76,   24,   21,   34,  111,   28,   29,   30,   99,
     32,  101,   34,   14,   72,   37,   46,  106,   40,   41,
     42,   43,   27,   45,   82,   47,   44,   49,   50,   34,
     52,  106,  107,   51,   76,   57,   58,    9,   10,   11,
     12,   46,   14,   21,   16,   51,   18,   19,  106,   21,
      1,   52,   24,   69,  102,  103,   28,   29,   30,   16,
     32,   25,   34,    1,  106,   37,   44,   31,   40,   41,
     42,   43,   70,   45,  100,   47,   27,   49,   50,   17,
     52,   59,   80,   99,   93,   57,   58,    9,   10,   11,
     12,   48,   14,   72,   16,  104,   18,   19,    9,   21,
     20,   12,   24,   82,   72,   16,   28,   29,   30,   79,
     32,   76,   34,   33,   82,   37,    1,    2,   40,   41,
     42,   43,   14,   45,   16,   47,   14,   49,   50,   76,
     52,  102,  103,   72,   80,   57,   58,    9,   10,   11,
     12,  106,   14,   82,   16,   80,   18,   19,    9,   21,
     99,   12,   24,   63,   64,   16,   28,   29,   30,  106,
     32,    6,   34,    8,   52,   37,   99,   43,   40,   41,
     42,   43,   43,   45,   50,   47,   99,   49,   50,   50,
     52,   36,   37,   38,   39,   57,   58,    9,   10,   11,
     12,   21,   14,   34,   16,    2,   18,   19,   53,   54,
     55,   56,   24,   15,   59,   46,   28,   29,   30,   21,
     32,  106,   34,  107,   44,   37,    7,    8,   40,   41,
     42,   43,   33,   45,   35,   47,   34,   49,   50,   99,
     52,   36,   37,   38,   39,   57,   58,    9,   10,   11,
     12,   34,   14,   33,   16,   35,   18,   19,   53,   54,
     55,   56,   24,   46,  103,   15,   28,   29,   30,   43,
     32,   64,   34,   81,   33,   37,   35,   51,   40,   41,
     42,   43,   33,   45,   35,   47,   99,   49,   50,   81,
     52,   70,   81,   43,   73,   57,   58,   65,   66,   67,
     68,   80,   70,   71,    7,   73,   74,   75,   33,   99,
     35,   33,   80,   35,   16,   83,   84,   96,   97,   98,
     13,   13,   90,   91,   92,   16,   94,   16,   96,   97,
     98,   16,   65,   66,   67,   68,   16,   70,   71,   14,
     73,   74,   75,   16,   32,   43,   70,   80,   32,   16,
     83,   84,   70,   77,   78,   73,   80,   90,   91,   92,
     34,   94,   80,   96,   97,   98,   65,   16,   67,   68,
     49,   70,   71,   91,   73,   74,   75,    1,   96,   97,
     98,   80,    1,    9,   83,   84,   12,   49,   51,   13,
     16,   90,   91,   92,   13,   94,   16,   96,   97,   98,
     65,   25,   67,   51,    1,   70,   25,   31,   73,   74,
     75,   16,   31,   15,    9,   80,   13,   12,   83,   84,
     72,   16,   48,   35,   76,   90,   91,   92,   25,   94,
     82,   96,   97,   98,   31,   22,  112,   65,  112,   67,
    112,  112,   70,  108,  109,   73,   74,   75,  112,  112,
    112,  112,   80,   48,  106,   83,   84,   72,  112,  112,
    112,   76,   90,   91,   92,  112,   94,   82,   96,   97,
     98,  112,  112,  112,   65,  112,   67,  112,  112,   70,
    108,  109,   73,   74,   75,  112,   77,  112,  112,   80,
    112,  106,   83,   84,  112,  112,  112,  112,  112,   90,
     91,   92,  112,   94,  112,   96,   97,   98,   65,  112,
     67,  112,  112,   70,  112,  112,   73,   74,   75,  112,
    112,  112,  112,   80,  112,  112,   83,   84,  112,  112,
    112,  112,  112,   90,   91,   92,  112,   94,  112,   96,
     97,   98,   65,  112,   67,  112,  112,   70,  105,  112,
     73,   74,   75,  112,  112,  112,  112,   80,  112,  112,
     83,   84,  112,  112,  112,  112,  112,   90,   91,   92,
    112,   94,  112,   96,   97,   98,   65,  112,   67,  112,
    112,   70,  105,  112,   73,   74,   75,  112,  112,  112,
    112,   80,  112,  112,   83,   84,  112,  112,  112,  112,
    112,   90,   91,   92,  112,   94,  112,   96,   97,   98,
    112,  112,  112,   65,  112,   67,  112,  112,   70,  112,
    109,   73,   74,   75,  112,  112,  112,  112,   80,  112,
      9,   83,   84,   12,  112,  112,  112,   16,   90,   91,
     92,  112,   94,   95,   96,   97,   98,   65,  112,   67,
    112,  112,   70,  112,  112,   73,   74,   75,  112,   77,
    112,  112,   80,  112,  112,   83,   84,  112,  112,   48,
    112,  112,   90,   91,   92,  112,   94,  112,   96,   97,
     98,   65,  112,   67,  112,  112,   70,  112,  112,   73,
     74,   75,  112,  112,  112,  112,   80,  112,  112,   83,
     84,  112,  112,  112,  112,  112,   90,   91,   92,  112,
     94,  112,   96,   97,   98,   65,  112,   67,  112,  112,
     70,  112,  112,   73,   74,   75,  112,  112,  112,  112,
     80,  112,  112,   83,   84,  112,  112,  112,  112,  112,
     90,   91,   92,  112,   94,  112,   96,   97,   98,   65,
    112,   67,  112,  112,   70,  112,  112,   73,   74,   75,
    112,  112,  112,  112,   80,  112,  112,   83,   84,  112,
    112,  112,  112,  112,   90,   91,   92,  112,   94,  112,
     96,   97,   98,   65,  112,   67,  112,  112,   70,  112,
    112,   73,   74,   75,  112,  112,  112,  112,   80,  112,
    112,   83,   84,  112,  112,  112,  112,  112,   90,   91,
     92,  112,   94,  112,   96,   97,   98,   65,  112,   67,
    112,  112,   70,  112,  112,   73,   74,   75,  112,  112,
    112,  112,   80,  112,  112,   83,   84,  112,  112,  112,
    112,  112,   90,   91,   92,  112,   94,  112,   96,   97,
     98,   65,  112,   67,  112,  112,   70,  112,  112,   73,
     74,   75,  112,  112,  112,  112,   80,  112,  112,   83,
     84,  112,  112,  112,  112,  112,   90,   91,   92,  112,
     94,  112,   96,   97,   98,   65,  112,   67,  112,  112,
     70,  112,  112,   73,   74,   75,  112,  112,  112,  112,
     80,  112,  112,   83,   84,  112,  112,  112,  112,  112,
     90,   91,   92,  112,   94,  112,   96,   97,   98,   65,
    112,   67,  112,  112,   70,  112,  112,   73,   74,   75,
    112,  112,  112,  112,   80,  112,  112,   83,   84,  112,
    112,  112,  112,  112,   90,   91,   92,  112,   94,  112,
     96,   97,   98,   65,  112,   67,  112,  112,   70,  112,
    112,   73,   74,   75,  112,  112,  112,  112,   80,  112,
    112,   83,   84,  112,  112,  112,  112,  112,   90,   91,
     92,  112,   94,  112,   96,   97,   98,   65,  112,   67,
    112,  112,   70,  112,  112,   73,   74,   75,  112,  112,
    112,  112,   80,  112,  112,   83,   84,  112,  112,  112,
    112,  112,   90,   91,   92,  112,   94,  112,   96,   97,
     98,   65,  112,   67,  112,  112,   70,  112,  112,   73,
     74,   75,  112,  112,  112,  112,   80,  112,  112,   83,
     84,  112,  112,  112,  112,  112,   90,   91,   92,  112,
     94,  112,   96,   97,   98,   65,  112,   67,  112,  112,
     70,  112,  112,   73,   74,   75,  112,  112,  112,  112,
     80,  112,  112,   83,   84,  112,  112,  112,  112,  112,
     90,   91,   92,  112,   94,  112,   96,   97,   98,   65,
    112,   67,  112,  112,   70,  112,  112,   73,   74,   75,
    112,  112,  112,  112,   80,  112,  112,   83,   84,  112,
    112,  112,  112,  112,   90,   91,   92,  112,   94,  112,
     96,   97,   98,   65,  112,   67,  112,  112,   70,  112,
    112,   73,   74,   75,  112,  112,  112,  112,   80,  112,
    112,   83,   84,  112,  112,  112,  112,  112,   90,   91,
     92,  112,   94,  112,   96,   97,   98,   65,  112,   67,
    112,  112,   70,  112,  112,   73,   74,   75,  112,  112,
    112,  112,   80,  112,  112,   83,   84,  112,  112,  112,
    112,  112,   90,   91,   92,  112,   94,  112,   96,   97,
     98,   65,  112,   67,  112,  112,   70,  112,  112,   73,
     74,   75,  112,  112,  112,  112,   80,  112,  112,   83,
     84,  112,  112,  112,  112,  112,   90,   91,   92,  112,
     94,  112,   96,   97,   98,   65,  112,   67,  112,  112,
     70,  112,  112,   73,   74,   75,  112,  112,  112,  112,
     80,  112,  112,   83,   84,  112,  112,  112,  112,  112,
     90,   91,   92,  112,   94,  112,   96,   97,   98,   65,
    112,   67,  112,  112,   70,  112,  112,   73,   74,   75,
    112,  112,  112,  112,   80,  112,  112,   83,   84,  112,
    112,  112,  112,  112,   90,   91,   92,  112,   94,  112,
     96,   97,   98,   65,  112,   67,  112,  112,   70,  112,
    112,   73,   74,   75,  112,  112,  112,  112,   80,  112,
    112,   83,   84,  112,  112,  112,  112,  112,   90,   91,
     92,  112,   94,  112,   96,   97,   98,   65,  112,   67,
    112,  112,   70,  112,  112,   73,   74,   75,  112,  112,
    112,  112,   80,  112,  112,   83,   84,  112,  112,  112,
    112,  112,   90,   91,   92,  112,   94,  112,   96,   97,
     98,   65,  112,   67,  112,  112,   70,  112,  112,   73,
     74,   75,  112,  112,  112,  112,   80,  112,  112,   83,
     84,  112,  112,  112,  112,  112,   90,   91,   92,  112,
     94,  112,   96,   97,   98,   65,  112,   67,  112,  112,
     70,  112,  112,   73,   74,   75,  112,  112,  112,  112,
     80,  112,  112,   83,   84,  112,  112,  112,  112,  112,
     90,   91,   92,  112,   94,  112,   96,   97,   98,   65,
    112,   67,  112,  112,   70,  112,  112,   73,   74,   75,
    112,  112,  112,  112,   80,  112,  112,   83,   84,  112,
    112,  112,  112,  112,   90,   91,   92,  112,   94,  112,
     96,   97,   98,   65,  112,   67,  112,  112,   70,  112,
    112,   73,   74,   75,  112,  112,  112,  112,   80,  112,
    112,   83,   84,  112,  112,  112,  112,  112,   90,   91,
     92,  112,   94,  112,   96,   97,   98,   65,  112,   67,
    112,  112,   70,  112,  112,   73,   74,   75,  112,  112,
    112,  112,   80,  112,  112,   83,   84,  112,  112,  112,
    112,  112,   90,   91,   92,  112,   94,  112,   96,   97,
     98,   65,  112,   67,  112,  112,   70,  112,  112,   73,
     74,   75,  112,  112,  112,  112,   80,  112,  112,   83,
     84,  112,  112,  112,  112,  112,   90,   91,   92,  112,
     94,  112,   96,   97,   98,   65,  112,   67,  112,  112,
     70,  112,  112,   73,   74,   75,  112,  112,  112,  112,
     80,  112,  112,   83,   84,  112,  112,  112,  112,  112,
     90,   91,   92,  112,   94,  112,   96,   97,   98,   65,
    112,   67,  112,  112,   70,  112,  112,   73,   74,   75,
    112,  112,  112,  112,   80,  112,  112,   83,   84,  112,
    112,  112,  112,  112,   90,   91,   92,  112,   94,  112,
     96,   97,   98,   65,  112,   67,   72,  112,   70,  112,
    112,   73,   74,  112,  112,  112,   82,  112,   80,   85,
     86,   87,   88,  112,  112,  112,  112,   89,   90,   91,
     92,  112,   94,  112,   96,   97,   98,   65,  112,   67,
     72,  112,   70,  112,  112,   73,   74,  112,  112,  112,
     82,  112,   80,   85,   86,   87,   88,  112,  112,  112,
    112,   89,   90,   91,   92,    3,   94,  112,   96,   97,
     98,    9,   10,   11,   12,  112,   14,  112,  112,  112,
     18,   19,    9,  112,  112,   12,   24,  112,   25,   16,
     28,   29,   30,  112,   31,   23,  112,   25,   25,   36,
     37,   38,   39,   31,   31,  112,  112,  112,   36,   37,
     38,   39,  112,  112,  112,  112,   53,   54,   55,   56,
     58,   59,  112,  112,    3,   53,   54,   55,   56,  112,
      9,   10,   11,   12,  112,   14,  112,   20,  112,   18,
     19,  112,  112,  112,  112,   24,  112,  112,   26,   28,
     29,   30,  112,   36,   37,   38,   39,  112,   36,   37,
     38,   39,  112,  112,  112,  112,  112,  112,  112,  112,
     53,   54,   55,   56,  112,   53,   54,   55,   56,   58,
     59,  112,  112,    3,    4,    5,    6,    2,  112,    9,
     10,   11,   12,  112,    9,  112,  112,   12,   18,   19,
     15,   16,   17,  112,   24,  112,   21,  112,   28,   29,
     30,   65,  112,   67,  112,  112,   70,  112,  112,   73,
     74,  112,  112,  112,  112,  112,   80,  112,   43,  112,
    112,   46,  112,   48,  112,   50,   90,   91,   92,  112,
     94,  112,   96,   97,   98,  112,   65,  112,   67,  112,
      1,   70,  112,  112,   73,   74,  112,  112,  112,  112,
    112,   80,   13,  112,  112,  112,   17,  112,  112,  112,
    112,   90,   91,   92,   25,   94,  112,   96,   97,   98,
     31,  112,   65,   34,   67,  112,   72,   70,  112,  112,
     73,   74,  112,  112,  112,   46,   82,   80,  112,   85,
     86,   87,   88,  112,  112,  112,  112,   90,   91,   92,
    112,   94,  112,   96,   97,   98,  112,   65,  112,   67,
    112,  112,   70,  112,  112,   73,   74,  112,  112,  112,
    112,  112,   80,  112,  112,  112,  112,  112,  112,  112,
    112,  112,   90,   91,   92,  112,   94,  112,   96,   97,
     98,  112,  112,   65,  112,   67,  112,  112,   70,  112,
    112,   73,   74,  112,  112,  112,  112,  112,   80,  112,
    112,  112,  112,  112,  112,  112,  112,  112,   90,   91,
     92,  112,   94,  112,   96,   97,   98,  112,   65,  112,
     67,  112,  112,   70,  112,  112,   73,   74,  112,  112,
    112,  112,  112,   80,  112,  112,  112,  112,  112,  112,
    112,  112,  112,   90,   91,   92,  112,   94,  112,   96,
     97,   98,  112,  112,   65,  112,   67,    2,  112,   70,
    112,  112,   73,   74,    9,  112,  112,   12,  112,   80,
    112,   16,   17,  112,  112,  112,   21,  112,  112,   90,
     91,   92,  112,   94,  112,   96,   97,   98,  112,  112,
      2,  112,  112,  112,  112,  112,  112,  112,   43,  112,
    112,   46,  112,   48,    2,   50,   51,  112,  112,  112,
    112,    9,  112,  112,   12,  112,  112,   15,   16,   17,
    112,    2,   34,   21,   36,   37,   38,   39,    9,  112,
    112,   12,  112,  112,   46,   16,   17,  112,  112,    2,
     21,   53,   54,   55,   56,   43,    9,  112,   46,   12,
     48,  112,   50,   16,   17,  112,  112,  112,   21,  112,
    112,  112,   43,  112,  112,   46,   13,   48,  112,   50,
    112,  112,  112,  112,  112,   35,   36,   37,   38,   39,
     43,  112,  112,   46,  112,   48,  112,   50,  112,   36,
     37,   38,   39,   53,   54,   55,   56,   13,  112,   36,
     37,   38,   39,   13,  112,  112,   53,   54,   55,   56,
     13,  112,  112,  112,   51,  112,   53,   54,   55,   56,
     36,   37,   38,   39,    2,  112,   36,   37,   38,   39,
    112,   13,  112,   36,   37,   38,   39,   53,   54,   55,
     56,  112,  112,   53,   54,   55,   56,  112,  112,  112,
     53,   54,   55,   56,   36,   37,   38,   39,   36,   37,
     38,   39,    9,  112,  112,   12,  112,  112,  112,   16,
     17,   53,   54,   55,   56,   53,   54,   55,   56,  112,
    112,  112,    9,  112,  112,   12,  112,  112,  112,   16,
    112,  112,  112,  112,  112,  112,   43,  112,   25,   46,
     27,   48,  112,   50,   31,
);
    const YY_SHIFT_USE_DFLT = -11;
    const YY_SHIFT_MAX = 239;
    public static $yy_shift_ofst = array(
    -11,   98,   98,  148,  198,  198,  248,  148,  148,  198,
    148,  248,   -2,   48,  298,  148,  148,  148,  298,  148,
    148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
    348,  148,  148,  148,  148,  148,  398,  148,  148,  148,
    448,  498,  498,  498,  498,  498,  498,  498,  498,  147,
   1962, 1953, 1953,   35, 1952, 2007, 2012, 2413, 2400, 2423,
   2444,  415, 2450, 2457, 2482, 2478,  465,  465,  465,  465,
    465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
    465,  465,  465,  465,  465,  465, 2139,   90,  143, 2011,
   2533, 1963,   36,  103,  143,  143,   90,   90,  235, 2070,
   2075,  634,   59,  636,  641,  663,  359,  359,  203,  221,
    269,  221,  306,  332,  196,  378,  378,  264,  385,  319,
    221,    5,    5,    5,    5,    5,    5,    5,    5,  112,
    112,   82,    5,  -11,  -11, 2315, 2362, 2379, 2397, 2513,
     49,  665,  409,  218,  221,  221,  458,  221,  382,  221,
    382,  221,  394,  394,  221,  221,  221,  221,  394,   40,
    394,  394,  394,  399,  394,  399,  394,  221,  221,  221,
    221,    5,  463,    5,    5,  463,    5,  462,  112,  112,
    112,  -11,  -11,  -11,  -11,  -11,  -11, 2348,   11,  100,
    -10,  190,  881,  141,  265,  292,  252,  425,  479,  350,
    313,  440,  240,  429,  477,  459,  480,  153,  486,  501,
    509,  535,  538,  510,  557,  567,  568,  558,  569,  571,
    575,  580,  585,  587,  562,  572,  576,  586,  593,  462,
    611,  581,  598,  640,  597,  612,  655,  658,  648,  673,
);
    const YY_REDUCE_USE_DFLT = -99;
    const YY_REDUCE_MAX = 186;
    public static $yy_reduce_ofst = array(
    109,  492,  527,  561,  595,  632,  669,  703,  737,  771,
    808,  842,  876,  910,  944,  978, 1012, 1046, 1080, 1114,
   1148, 1182, 1216, 1250, 1284, 1318, 1352, 1386, 1420, 1454,
   1488, 1522, 1556, 1590, 1624, 1658, 1692, 1726, 1760, 1794,
   1828, 1862, 2036, 2071, 2107, 2142, 2178, 2213, 2249,  542,
   1824, 1858, 2104,  481,  114,   66,   66,   66,   66,   66,
     66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
     66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
     66,   66,   66,   66,   66,   66,  608,  536,  645,  164,
     20,  101,  -98,   34,  181,  212,  -57,  174,  195,    3,
    254,   -5,  -79,  228,  228,  228,  180,   -5,  222,   51,
    272,  291,  302,  305,  222,  -75,  261,  228,  228,  228,
    331,  323,  228,  228,  228,  228,  228,  228,  228,  222,
    299,  228,  228,  360,  228,  102,  102,  102,  102,  102,
     85,  122,  102,  102,  188,  188,  300,  188,  324,  188,
    335,  188,  244,  244,  188,  188,  188,  188,  244,  321,
    244,  244,  244,  337,  244,  347,  244,  188,  188,  188,
    188,  375,  376,  375,  375,  376,  375,  400,  421,  421,
    421,  467,  452,  468,  471,  447,  470,
);
    public static $yyExpectedTokens = array(
         array(),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(2, 9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 39, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 51, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(14, 16, 47, 49, 52, ),
         array(23, 25, 31, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(25, 31, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(25, 31, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(14, 16, 49, 52, ),
         array(3, 9, 10, 11, 12, 14, 18, 19, 24, 28, 29, 30, 58, 59, ),
         array(20, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(26, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(13, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(35, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 51, 53, 54, 55, 56, ),
         array(13, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, 59, ),
         array(13, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(13, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(2, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(13, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(1, 13, 17, 25, 31, 34, 46, ),
         array(14, 34, 52, ),
         array(1, 25, 31, ),
         array(3, 9, 10, 11, 12, 14, 18, 19, 24, 28, 29, 30, 58, 59, ),
         array(9, 12, 16, 25, 27, 31, ),
         array(9, 12, 16, 25, 31, ),
         array(17, 43, 50, ),
         array(15, 17, 46, ),
         array(1, 25, 31, ),
         array(1, 25, 31, ),
         array(14, 34, 52, ),
         array(14, 34, 52, ),
         array(1, 2, ),
         array(3, 4, 5, 6, 9, 10, 11, 12, 18, 19, 24, 28, 29, 30, ),
         array(2, 9, 12, 15, 16, 17, 21, 43, 46, 48, 50, ),
         array(9, 12, 16, 48, ),
         array(12, 14, 16, 52, ),
         array(1, 13, 25, 31, ),
         array(1, 13, 25, 31, ),
         array(1, 13, 25, 31, ),
         array(9, 12, 16, ),
         array(9, 12, 16, ),
         array(15, 17, 46, ),
         array(25, 31, ),
         array(14, 52, ),
         array(25, 31, ),
         array(25, 31, ),
         array(1, 17, ),
         array(17, 46, ),
         array(14, 16, ),
         array(14, 16, ),
         array(1, 51, ),
         array(1, 2, ),
         array(1, 27, ),
         array(25, 31, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(17, ),
         array(17, ),
         array(1, ),
         array(1, ),
         array(),
         array(),
         array(2, 9, 12, 16, 17, 21, 43, 46, 48, 50, 51, ),
         array(2, 9, 12, 15, 16, 17, 21, 43, 46, 48, 50, ),
         array(2, 9, 12, 16, 17, 21, 43, 46, 48, 50, ),
         array(2, 9, 12, 16, 17, 21, 43, 46, 48, 50, ),
         array(9, 12, 16, 17, 43, 46, 48, 50, ),
         array(12, 14, 16, 32, 52, ),
         array(9, 12, 16, 48, ),
         array(9, 12, 16, ),
         array(15, 43, 50, ),
         array(25, 31, ),
         array(25, 31, ),
         array(15, 21, ),
         array(25, 31, ),
         array(14, 52, ),
         array(25, 31, ),
         array(14, 52, ),
         array(25, 31, ),
         array(43, 50, ),
         array(43, 50, ),
         array(25, 31, ),
         array(25, 31, ),
         array(25, 31, ),
         array(25, 31, ),
         array(43, 50, ),
         array(12, 34, ),
         array(43, 50, ),
         array(43, 50, ),
         array(43, 50, ),
         array(43, 50, ),
         array(43, 50, ),
         array(43, 50, ),
         array(43, 50, ),
         array(25, 31, ),
         array(25, 31, ),
         array(25, 31, ),
         array(25, 31, ),
         array(1, ),
         array(2, ),
         array(1, ),
         array(1, ),
         array(2, ),
         array(1, ),
         array(34, ),
         array(17, ),
         array(17, ),
         array(17, ),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(2, 34, 36, 37, 38, 39, 46, 53, 54, 55, 56, ),
         array(13, 20, 22, 25, 31, 33, 35, 43, ),
         array(13, 15, 25, 31, 34, 46, ),
         array(13, 21, 25, 31, 44, ),
         array(13, 21, 25, 31, 44, ),
         array(9, 12, 16, 48, ),
         array(34, 43, 46, 51, ),
         array(27, 34, 46, ),
         array(21, 44, 59, ),
         array(21, 44, 51, ),
         array(6, 8, ),
         array(7, 8, ),
         array(20, 33, ),
         array(16, 48, ),
         array(21, 44, ),
         array(34, 46, ),
         array(34, 46, ),
         array(34, 46, ),
         array(33, 35, ),
         array(33, 35, ),
         array(33, 51, ),
         array(43, 51, ),
         array(33, 35, ),
         array(33, 35, ),
         array(33, 35, ),
         array(33, 35, ),
         array(15, 43, ),
         array(7, ),
         array(13, ),
         array(13, ),
         array(16, ),
         array(16, ),
         array(16, ),
         array(16, ),
         array(16, ),
         array(14, ),
         array(16, ),
         array(43, ),
         array(32, ),
         array(32, ),
         array(34, ),
         array(16, ),
         array(34, ),
         array(16, ),
         array(49, ),
         array(49, ),
         array(16, ),
         array(51, ),
         array(51, ),
         array(16, ),
         array(15, ),
         array(35, ),
         array(22, ),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
);
    public static $yy_default = array(
    350,  539,  539,  539,  524,  524,  539,  501,  501,  539,
    452,  539,  539,  539,  539,  539,  539,  539,  539,  539,
    539,  539,  539,  539,  539,  539,  539,  539,  539,  539,
    539,  539,  539,  539,  539,  539,  539,  539,  539,  539,
    539,  539,  539,  539,  539,  539,  539,  539,  539,  539,
    390,  369,  390,  539,  539,  539,  395,  539,  539,  539,
    363,  539,  539,  539,  539,  539,  374,  500,  413,  420,
    499,  525,  527,  526,  419,  421,  418,  422,  451,  449,
    397,  401,  402,  392,  395,  363,  433,  539,  390,  539,
    390,  390,  514,  454,  390,  390,  539,  539,  381,  340,
    453,  466,  539,  404,  404,  404,  466,  466,  454,  390,
    539,  390,  390,  384,  454,  539,  539,  404,  404,  404,
    371,  386,  404,  411,  424,  425,  426,  412,  417,  454,
    511,  424,  410,  348,  508,  453,  453,  453,  453,  453,
    539,  468,  466,  482,  360,  370,  539,  373,  539,  378,
    539,  379,  463,  464,  364,  366,  367,  368,  492,  466,
    491,  494,  493,  457,  458,  459,  460,  380,  376,  377,
    372,  382,  502,  385,  387,  503,  442,  466,  488,  515,
    512,  348,  507,  507,  507,  466,  466,  433,  429,  433,
    423,  423,  467,  433,  433,  423,  423,  346,  539,  539,
    539,  423,  433,  443,  539,  539,  539,  539,  429,  539,
    461,  461,  539,  429,  539,  539,  539,  539,  539,  539,
    539,  539,  539,  539,  429,  431,  539,  513,  539,  482,
    539,  539,  539,  539,  539,  438,  539,  539,  539,  398,
    341,  342,  343,  344,  345,  347,  349,  351,  352,  353,
    354,  355,  356,  357,  359,  388,  389,  484,  485,  486,
    506,  383,  504,  505,  427,  436,  437,  446,  447,  465,
    469,  470,  471,  405,  406,  407,  408,  409,  428,  430,
    432,  434,  438,  439,  440,  414,  415,  416,  441,  444,
    445,  479,  477,  516,  517,  518,  519,  455,  456,  490,
    461,  462,  483,  498,  358,  489,  535,  536,  528,  529,
    530,  533,  532,  534,  537,  538,  531,  521,  523,  522,
    520,  495,  480,  478,  476,  473,  474,  475,  481,  496,
    497,  435,  472,  510,  487,  482,  391,  375,  399,  403,
);
    const YYNOCODE = 113;
    const YYSTACKDEPTH = 500;
    const YYNSTATE = 340;
    const YYNRULE = 199;
    const YYERRORSYMBOL = 60;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    public static $yyFallback = array(
    );
    public function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        $this->yyTraceFILE = $TraceFILE;
        $this->yyTracePrompt = $zTracePrompt;
    }

    public function PrintTrace()
    {
        $this->yyTraceFILE = fopen('php://output', 'w');
        $this->yyTracePrompt = '<br>';
    }

    public $yyTraceFILE;
    public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array(
  '$',             'VERT',          'COLON',         'TEXT',        
  'STRIPON',       'STRIPOFF',      'LITERALSTART',  'LITERALEND',  
  'LITERAL',       'SIMPELOUTPUT',  'SIMPLETAG',     'SMARTYBLOCKCHILDPARENT',
  'LDEL',          'RDEL',          'DOLLARID',      'EQUAL',       
  'ID',            'PTR',           'LDELIF',        'LDELFOR',     
  'SEMICOLON',     'INCDEC',        'TO',            'STEP',        
  'LDELFOREACH',   'SPACE',         'AS',            'APTR',        
  'LDELSETFILTER',  'CLOSETAG',      'LDELSLASH',     'ATTR',        
  'INTEGER',       'COMMA',         'OPENP',         'CLOSEP',      
  'MATH',          'UNIMATH',       'ISIN',          'QMARK',       
  'NOT',           'TYPECAST',      'HEX',           'DOT',         
  'INSTANCEOF',    'SINGLEQUOTESTRING',  'DOUBLECOLON',   'NAMESPACE',   
  'AT',            'HATCH',         'OPENB',         'CLOSEB',      
  'DOLLAR',        'LOGOP',         'SLOGOP',        'TLOGOP',      
  'SINGLECOND',    'ARRAYOPEN',     'QUOTE',         'BACKTICK',    
  'error',         'start',         'template',      'literal_e2',  
  'literal_e1',    'smartytag',     'tagbody',       'tag',         
  'outattr',       'eqoutattr',     'varindexed',    'output',      
  'attributes',    'variablevalue',  'value',         'expr',        
  'modifierlist',  'statement',     'statements',    'foraction',   
  'varvar',        'modparameters',  'attribute',     'nullcoalescing',
  'ternary',       'tlop',          'lop',           'scond',       
  'isin',          'array',         'function',      'ns1',         
  'doublequoted_with_quotes',  'static_class_access',  'arraydef',      'variablelist',
  'variable',      'object',        'configvariable',  'arrayindex',  
  'indexdef',      'varvarele',     'objectchain',   'objectelement',
  'method',        'params',        'modifier',      'modparameter',
  'arrayelements',  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    public static $yyRuleName = array(
  'start ::= template',
  'template ::= template TEXT',
  'template ::= template STRIPON',
  'template ::= template STRIPOFF',
  'template ::= template LITERALSTART literal_e2 LITERALEND',
  'literal_e2 ::= literal_e1 LITERALSTART literal_e1 LITERALEND',
  'literal_e2 ::= literal_e1',
  'literal_e1 ::= literal_e1 LITERAL',
  'literal_e1 ::=',
  'template ::= template smartytag',
  'template ::=',
  'smartytag ::= SIMPELOUTPUT',
  'smartytag ::= SIMPLETAG',
  'smartytag ::= SMARTYBLOCKCHILDPARENT',
  'smartytag ::= LDEL tagbody RDEL',
  'smartytag ::= tag RDEL',
  'tagbody ::= outattr',
  'tagbody ::= DOLLARID eqoutattr',
  'tagbody ::= varindexed eqoutattr',
  'eqoutattr ::= EQUAL outattr',
  'outattr ::= output attributes',
  'output ::= variablevalue',
  'output ::= value',
  'output ::= expr',
  'tag ::= LDEL ID attributes',
  'tag ::= LDEL ID',
  'tag ::= LDEL ID modifierlist attributes',
  'tag ::= LDEL ID PTR ID attributes',
  'tag ::= LDEL ID PTR ID modifierlist attributes',
  'tag ::= LDELIF expr',
  'tag ::= LDELIF expr attributes',
  'tag ::= LDELIF statement',
  'tag ::= LDELIF statement attributes',
  'tag ::= LDELFOR statements SEMICOLON expr SEMICOLON varindexed foraction attributes',
  'foraction ::= EQUAL expr',
  'foraction ::= INCDEC',
  'tag ::= LDELFOR statement TO expr attributes',
  'tag ::= LDELFOR statement TO expr STEP expr attributes',
  'tag ::= LDELFOREACH SPACE expr AS varvar attributes',
  'tag ::= LDELFOREACH SPACE expr AS varvar APTR varvar attributes',
  'tag ::= LDELFOREACH attributes',
  'tag ::= LDELSETFILTER ID modparameters',
  'tag ::= LDELSETFILTER ID modparameters modifierlist',
  'smartytag ::= CLOSETAG',
  'tag ::= LDELSLASH ID',
  'tag ::= LDELSLASH ID modifierlist',
  'tag ::= LDELSLASH ID PTR ID',
  'tag ::= LDELSLASH ID PTR ID modifierlist',
  'attributes ::= attributes attribute',
  'attributes ::= attribute',
  'attributes ::=',
  'attribute ::= SPACE ID EQUAL ID',
  'attribute ::= ATTR expr',
  'attribute ::= ATTR value',
  'attribute ::= SPACE ID',
  'attribute ::= SPACE expr',
  'attribute ::= SPACE value',
  'attribute ::= SPACE INTEGER EQUAL expr',
  'statements ::= statement',
  'statements ::= statements COMMA statement',
  'statement ::= DOLLARID EQUAL INTEGER',
  'statement ::= DOLLARID EQUAL expr',
  'statement ::= varindexed EQUAL expr',
  'statement ::= OPENP statement CLOSEP',
  'expr ::= value',
  'expr ::= nullcoalescing',
  'expr ::= ternary',
  'expr ::= INCDEC DOLLARID',
  'expr ::= DOLLARID INCDEC',
  'expr ::= DOLLARID COLON ID',
  'expr ::= expr MATH value',
  'expr ::= expr UNIMATH value',
  'expr ::= expr tlop value',
  'expr ::= expr lop expr',
  'expr ::= expr scond',
  'isin ::= ISIN',
  'expr ::= expr isin array',
  'expr ::= expr isin value',
  'nullcoalescing ::= expr QMARK QMARK expr',
  'ternary ::= expr QMARK DOLLARID COLON expr',
  'ternary ::= expr QMARK value COLON expr',
  'ternary ::= expr QMARK expr COLON expr',
  'ternary ::= expr QMARK COLON expr',
  'value ::= variablevalue',
  'value ::= UNIMATH value',
  'value ::= NOT value',
  'value ::= TYPECAST value',
  'value ::= variablevalue INCDEC',
  'value ::= HEX',
  'value ::= INTEGER',
  'value ::= INTEGER DOT INTEGER',
  'value ::= INTEGER DOT',
  'value ::= DOT INTEGER',
  'value ::= ID',
  'value ::= function',
  'value ::= OPENP expr CLOSEP',
  'value ::= variablevalue INSTANCEOF ns1',
  'value ::= variablevalue INSTANCEOF variablevalue',
  'value ::= SINGLEQUOTESTRING',
  'value ::= doublequoted_with_quotes',
  'value ::= varindexed DOUBLECOLON static_class_access',
  'value ::= smartytag',
  'value ::= value modifierlist',
  'value ::= NAMESPACE',
  'value ::= arraydef',
  'value ::= ns1 DOUBLECOLON static_class_access',
  'ns1 ::= ID',
  'ns1 ::= NAMESPACE',
  'variablelist ::= variablelist COMMA variable',
  'variablelist ::= variablelist COMMA expr',
  'variablelist ::= variable',
  'variablelist ::= expr',
  'variablelist ::=',
  'variable ::= DOLLARID',
  'variable ::= varindexed',
  'variable ::= varvar AT ID',
  'variable ::= object',
  'configvariable ::= HATCH ID HATCH',
  'configvariable ::= HATCH ID HATCH arrayindex',
  'configvariable ::= HATCH variablevalue HATCH',
  'configvariable ::= HATCH variablevalue HATCH arrayindex',
  'variablevalue ::= variable',
  'variablevalue ::= configvariable',
  'varindexed ::= DOLLARID arrayindex',
  'varindexed ::= varvar arrayindex',
  'arrayindex ::= arrayindex indexdef',
  'arrayindex ::=',
  'indexdef ::= DOT DOLLARID',
  'indexdef ::= DOT varvar',
  'indexdef ::= DOT varvar AT ID',
  'indexdef ::= DOT ID',
  'indexdef ::= DOT INTEGER',
  'indexdef ::= DOT LDEL expr RDEL',
  'indexdef ::= OPENB ID CLOSEB',
  'indexdef ::= OPENB ID DOT ID CLOSEB',
  'indexdef ::= OPENB SINGLEQUOTESTRING CLOSEB',
  'indexdef ::= OPENB INTEGER CLOSEB',
  'indexdef ::= OPENB DOLLARID CLOSEB',
  'indexdef ::= OPENB variablevalue CLOSEB',
  'indexdef ::= OPENB value CLOSEB',
  'indexdef ::= OPENB expr CLOSEB',
  'indexdef ::= OPENB CLOSEB',
  'varvar ::= DOLLARID',
  'varvar ::= DOLLAR',
  'varvar ::= varvar varvarele',
  'varvarele ::= ID',
  'varvarele ::= SIMPELOUTPUT',
  'varvarele ::= LDEL expr RDEL',
  'object ::= varindexed objectchain',
  'objectchain ::= objectelement',
  'objectchain ::= objectchain objectelement',
  'objectelement ::= PTR ID arrayindex',
  'objectelement ::= PTR varvar arrayindex',
  'objectelement ::= PTR LDEL expr RDEL arrayindex',
  'objectelement ::= PTR ID LDEL expr RDEL arrayindex',
  'objectelement ::= PTR method',
  'function ::= ns1 OPENP variablelist CLOSEP',
  'method ::= ID OPENP params CLOSEP',
  'method ::= DOLLARID OPENP params CLOSEP',
  'params ::= params COMMA expr',
  'params ::= expr',
  'params ::=',
  'modifierlist ::= modifierlist modifier modparameters',
  'modifierlist ::= modifier modparameters',
  'modifier ::= VERT AT ID',
  'modifier ::= VERT ID',
  'modparameters ::= modparameters modparameter',
  'modparameters ::=',
  'modparameter ::= COLON value',
  'modparameter ::= COLON UNIMATH value',
  'modparameter ::= COLON array',
  'static_class_access ::= method',
  'static_class_access ::= method objectchain',
  'static_class_access ::= ID',
  'static_class_access ::= DOLLARID arrayindex',
  'static_class_access ::= DOLLARID arrayindex objectchain',
  'lop ::= LOGOP',
  'lop ::= SLOGOP',
  'tlop ::= TLOGOP',
  'scond ::= SINGLECOND',
  'arraydef ::= OPENB arrayelements CLOSEB',
  'arraydef ::= ARRAYOPEN arrayelements CLOSEP',
  'arrayelements ::= arrayelement',
  'arrayelements ::= arrayelements COMMA arrayelement',
  'arrayelements ::=',
  'arrayelement ::= value APTR expr',
  'arrayelement ::= ID APTR expr',
  'arrayelement ::= expr',
  'doublequoted_with_quotes ::= QUOTE QUOTE',
  'doublequoted_with_quotes ::= QUOTE doublequoted QUOTE',
  'doublequoted ::= doublequoted doublequotedcontent',
  'doublequoted ::= doublequotedcontent',
  'doublequotedcontent ::= BACKTICK variablevalue BACKTICK',
  'doublequotedcontent ::= BACKTICK expr BACKTICK',
  'doublequotedcontent ::= DOLLARID',
  'doublequotedcontent ::= LDEL variablevalue RDEL',
  'doublequotedcontent ::= LDEL expr RDEL',
  'doublequotedcontent ::= smartytag',
  'doublequotedcontent ::= TEXT',
    );

    public function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return 'Unknown';
        }
    }

    public static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    public function yy_pop_parser_stack()
    {
        if (empty($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if ($this->yyTraceFILE && $this->yyidx >= 0) {
            fwrite($this->yyTraceFILE,
                $this->yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;

        return $yymajor;
    }

    public function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource($this->yyTraceFILE)) {
            fclose($this->yyTraceFILE);
        }
    }

    public function yy_get_expected_tokens($token)
    {
        static $res3 = array();
        static $res4 = array();
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (isset($res3[$state][$token])) {
            if ($res3[$state][$token]) {
                return $expected;
            }
        } else {
            if ($res3[$state][$token] = in_array($token, self::$yyExpectedTokens[$state], true)) {
                return $expected;
            }
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ === 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno][1];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno][0]);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                        if (isset($res4[$nextstate][$token])) {
                            if ($res4[$nextstate][$token]) {
                                $this->yyidx = $yyidx;
                                $this->yystack = $stack;
                                return array_unique($expected);
                            }
                        } else {
                            if ($res4[$nextstate][$token] = in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                                $this->yyidx = $yyidx;
                                $this->yystack = $stack;
                                return array_unique($expected);
                            }
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = (object) ['stateno' => null, 'major' => null, 'minor' => null];
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno][0];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate === self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return array_unique($expected);
    }

    public function yy_is_expected_token($token)
    {
        static $res = array();
        static $res2 = array();
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (isset($res[$state][$token])) {
            if ($res[$state][$token]) {
                return true;
            }
        } else {
            if ($res[$state][$token] = in_array($token, self::$yyExpectedTokens[$state], true)) {
                return true;
            }
       }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ === 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno][1];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno][0]);
                    if (isset($res2[$nextstate][$token])) {
                        if ($res2[$nextstate][$token]) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return true;
                        }
                    } else {
                        if ($res2[$nextstate][$token] = (isset(self::$yyExpectedTokens[$nextstate]) && in_array($token, self::$yyExpectedTokens[$nextstate], true))) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return true;
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = (object) ['stateno' => null, 'major' => null, 'minor' => null];
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno][0];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate === self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return true;
    }

   public function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead === self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if ($this->yyTraceFILE) {
                    fwrite($this->yyTraceFILE, $this->yyTracePrompt . 'FALLBACK ' .
                        $this->yyTokenName[$iLookAhead] . ' => ' .
                        $this->yyTokenName[$iFallback] . "\n");
                }

                return $this->yy_find_shift_action($iFallback);
            }

            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    public function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i === self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead === self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    public function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if ($this->yyTraceFILE) {
                fprintf($this->yyTraceFILE, "%sStack Overflow!\n", $this->yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
// line 232 "src/Parser/TemplateParser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error('Stack overflow in template parser');

            return;
        }
        $yytos = (object) ['stateno' => null, 'major' => null, 'minor' => null];
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        $this->yystack[] = $yytos;
        if ($this->yyTraceFILE && $this->yyidx > 0) {
            fprintf($this->yyTraceFILE, "%sShift %d\n", $this->yyTracePrompt,
                $yyNewState);
            fprintf($this->yyTraceFILE, "%sStack:", $this->yyTracePrompt);
            for ($i = 1; $i <= $this->yyidx; $i++) {
                fprintf($this->yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite($this->yyTraceFILE,"\n");
        }
    }

    public static $yyRuleInfo = array(
  array( 0 => 61, 1 => 1 ),
  array( 0 => 62, 1 => 2 ),
  array( 0 => 62, 1 => 2 ),
  array( 0 => 62, 1 => 2 ),
  array( 0 => 62, 1 => 4 ),
  array( 0 => 63, 1 => 4 ),
  array( 0 => 63, 1 => 1 ),
  array( 0 => 64, 1 => 2 ),
  array( 0 => 64, 1 => 0 ),
  array( 0 => 62, 1 => 2 ),
  array( 0 => 62, 1 => 0 ),
  array( 0 => 65, 1 => 1 ),
  array( 0 => 65, 1 => 1 ),
  array( 0 => 65, 1 => 1 ),
  array( 0 => 65, 1 => 3 ),
  array( 0 => 65, 1 => 2 ),
  array( 0 => 66, 1 => 1 ),
  array( 0 => 66, 1 => 2 ),
  array( 0 => 66, 1 => 2 ),
  array( 0 => 69, 1 => 2 ),
  array( 0 => 68, 1 => 2 ),
  array( 0 => 71, 1 => 1 ),
  array( 0 => 71, 1 => 1 ),
  array( 0 => 71, 1 => 1 ),
  array( 0 => 67, 1 => 3 ),
  array( 0 => 67, 1 => 2 ),
  array( 0 => 67, 1 => 4 ),
  array( 0 => 67, 1 => 5 ),
  array( 0 => 67, 1 => 6 ),
  array( 0 => 67, 1 => 2 ),
  array( 0 => 67, 1 => 3 ),
  array( 0 => 67, 1 => 2 ),
  array( 0 => 67, 1 => 3 ),
  array( 0 => 67, 1 => 8 ),
  array( 0 => 79, 1 => 2 ),
  array( 0 => 79, 1 => 1 ),
  array( 0 => 67, 1 => 5 ),
  array( 0 => 67, 1 => 7 ),
  array( 0 => 67, 1 => 6 ),
  array( 0 => 67, 1 => 8 ),
  array( 0 => 67, 1 => 2 ),
  array( 0 => 67, 1 => 3 ),
  array( 0 => 67, 1 => 4 ),
  array( 0 => 65, 1 => 1 ),
  array( 0 => 67, 1 => 2 ),
  array( 0 => 67, 1 => 3 ),
  array( 0 => 67, 1 => 4 ),
  array( 0 => 67, 1 => 5 ),
  array( 0 => 72, 1 => 2 ),
  array( 0 => 72, 1 => 1 ),
  array( 0 => 72, 1 => 0 ),
  array( 0 => 82, 1 => 4 ),
  array( 0 => 82, 1 => 2 ),
  array( 0 => 82, 1 => 2 ),
  array( 0 => 82, 1 => 2 ),
  array( 0 => 82, 1 => 2 ),
  array( 0 => 82, 1 => 2 ),
  array( 0 => 82, 1 => 4 ),
  array( 0 => 78, 1 => 1 ),
  array( 0 => 78, 1 => 3 ),
  array( 0 => 77, 1 => 3 ),
  array( 0 => 77, 1 => 3 ),
  array( 0 => 77, 1 => 3 ),
  array( 0 => 77, 1 => 3 ),
  array( 0 => 75, 1 => 1 ),
  array( 0 => 75, 1 => 1 ),
  array( 0 => 75, 1 => 1 ),
  array( 0 => 75, 1 => 2 ),
  array( 0 => 75, 1 => 2 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 2 ),
  array( 0 => 88, 1 => 1 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 83, 1 => 4 ),
  array( 0 => 84, 1 => 5 ),
  array( 0 => 84, 1 => 5 ),
  array( 0 => 84, 1 => 5 ),
  array( 0 => 84, 1 => 4 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 91, 1 => 1 ),
  array( 0 => 91, 1 => 1 ),
  array( 0 => 95, 1 => 3 ),
  array( 0 => 95, 1 => 3 ),
  array( 0 => 95, 1 => 1 ),
  array( 0 => 95, 1 => 1 ),
  array( 0 => 95, 1 => 0 ),
  array( 0 => 96, 1 => 1 ),
  array( 0 => 96, 1 => 1 ),
  array( 0 => 96, 1 => 3 ),
  array( 0 => 96, 1 => 1 ),
  array( 0 => 98, 1 => 3 ),
  array( 0 => 98, 1 => 4 ),
  array( 0 => 98, 1 => 3 ),
  array( 0 => 98, 1 => 4 ),
  array( 0 => 73, 1 => 1 ),
  array( 0 => 73, 1 => 1 ),
  array( 0 => 70, 1 => 2 ),
  array( 0 => 70, 1 => 2 ),
  array( 0 => 99, 1 => 2 ),
  array( 0 => 99, 1 => 0 ),
  array( 0 => 100, 1 => 2 ),
  array( 0 => 100, 1 => 2 ),
  array( 0 => 100, 1 => 4 ),
  array( 0 => 100, 1 => 2 ),
  array( 0 => 100, 1 => 2 ),
  array( 0 => 100, 1 => 4 ),
  array( 0 => 100, 1 => 3 ),
  array( 0 => 100, 1 => 5 ),
  array( 0 => 100, 1 => 3 ),
  array( 0 => 100, 1 => 3 ),
  array( 0 => 100, 1 => 3 ),
  array( 0 => 100, 1 => 3 ),
  array( 0 => 100, 1 => 3 ),
  array( 0 => 100, 1 => 3 ),
  array( 0 => 100, 1 => 2 ),
  array( 0 => 80, 1 => 1 ),
  array( 0 => 80, 1 => 1 ),
  array( 0 => 80, 1 => 2 ),
  array( 0 => 101, 1 => 1 ),
  array( 0 => 101, 1 => 1 ),
  array( 0 => 101, 1 => 3 ),
  array( 0 => 97, 1 => 2 ),
  array( 0 => 102, 1 => 1 ),
  array( 0 => 102, 1 => 2 ),
  array( 0 => 103, 1 => 3 ),
  array( 0 => 103, 1 => 3 ),
  array( 0 => 103, 1 => 5 ),
  array( 0 => 103, 1 => 6 ),
  array( 0 => 103, 1 => 2 ),
  array( 0 => 90, 1 => 4 ),
  array( 0 => 104, 1 => 4 ),
  array( 0 => 104, 1 => 4 ),
  array( 0 => 105, 1 => 3 ),
  array( 0 => 105, 1 => 1 ),
  array( 0 => 105, 1 => 0 ),
  array( 0 => 76, 1 => 3 ),
  array( 0 => 76, 1 => 2 ),
  array( 0 => 106, 1 => 3 ),
  array( 0 => 106, 1 => 2 ),
  array( 0 => 81, 1 => 2 ),
  array( 0 => 81, 1 => 0 ),
  array( 0 => 107, 1 => 2 ),
  array( 0 => 107, 1 => 3 ),
  array( 0 => 107, 1 => 2 ),
  array( 0 => 93, 1 => 1 ),
  array( 0 => 93, 1 => 2 ),
  array( 0 => 93, 1 => 1 ),
  array( 0 => 93, 1 => 2 ),
  array( 0 => 93, 1 => 3 ),
  array( 0 => 86, 1 => 1 ),
  array( 0 => 86, 1 => 1 ),
  array( 0 => 85, 1 => 1 ),
  array( 0 => 87, 1 => 1 ),
  array( 0 => 94, 1 => 3 ),
  array( 0 => 94, 1 => 3 ),
  array( 0 => 108, 1 => 1 ),
  array( 0 => 108, 1 => 3 ),
  array( 0 => 108, 1 => 0 ),
  array( 0 => 109, 1 => 3 ),
  array( 0 => 109, 1 => 3 ),
  array( 0 => 109, 1 => 1 ),
  array( 0 => 92, 1 => 2 ),
  array( 0 => 92, 1 => 3 ),
  array( 0 => 110, 1 => 2 ),
  array( 0 => 110, 1 => 1 ),
  array( 0 => 111, 1 => 3 ),
  array( 0 => 111, 1 => 3 ),
  array( 0 => 111, 1 => 1 ),
  array( 0 => 111, 1 => 3 ),
  array( 0 => 111, 1 => 3 ),
  array( 0 => 111, 1 => 1 ),
  array( 0 => 111, 1 => 1 ),
    );

    public static $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 2,
        3 => 3,
        4 => 4,
        5 => 5,
        6 => 6,
        21 => 6,
        22 => 6,
        23 => 6,
        35 => 6,
        55 => 6,
        56 => 6,
        64 => 6,
        65 => 6,
        66 => 6,
        83 => 6,
        88 => 6,
        89 => 6,
        94 => 6,
        98 => 6,
        99 => 6,
        103 => 6,
        104 => 6,
        106 => 6,
        122 => 6,
        182 => 6,
        187 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        16 => 16,
        17 => 17,
        18 => 18,
        19 => 19,
        20 => 20,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 28,
        29 => 29,
        30 => 30,
        32 => 30,
        31 => 31,
        33 => 33,
        34 => 34,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        42 => 42,
        43 => 43,
        44 => 44,
        45 => 45,
        46 => 46,
        47 => 47,
        48 => 48,
        49 => 49,
        58 => 49,
        110 => 49,
        111 => 49,
        160 => 49,
        164 => 49,
        168 => 49,
        170 => 49,
        50 => 50,
        112 => 50,
        161 => 50,
        167 => 50,
        51 => 51,
        52 => 52,
        53 => 52,
        54 => 54,
        145 => 54,
        57 => 57,
        59 => 59,
        60 => 60,
        61 => 60,
        62 => 62,
        63 => 63,
        67 => 67,
        68 => 68,
        69 => 69,
        70 => 70,
        71 => 70,
        72 => 72,
        73 => 73,
        74 => 74,
        75 => 75,
        76 => 76,
        77 => 77,
        78 => 78,
        79 => 79,
        80 => 80,
        81 => 80,
        82 => 82,
        84 => 84,
        86 => 84,
        87 => 84,
        125 => 84,
        85 => 85,
        90 => 90,
        91 => 91,
        92 => 92,
        93 => 93,
        95 => 95,
        96 => 96,
        97 => 96,
        100 => 100,
        101 => 101,
        102 => 102,
        105 => 105,
        107 => 107,
        108 => 108,
        109 => 108,
        159 => 108,
        113 => 113,
        114 => 114,
        115 => 115,
        116 => 116,
        117 => 117,
        118 => 118,
        119 => 119,
        120 => 120,
        121 => 121,
        123 => 123,
        124 => 124,
        126 => 126,
        184 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        140 => 132,
        133 => 133,
        134 => 134,
        135 => 135,
        136 => 135,
        138 => 135,
        139 => 135,
        137 => 137,
        141 => 141,
        142 => 142,
        143 => 143,
        188 => 143,
        144 => 144,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        152 => 152,
        153 => 153,
        154 => 154,
        155 => 155,
        156 => 156,
        157 => 157,
        158 => 158,
        162 => 162,
        163 => 163,
        165 => 165,
        166 => 166,
        169 => 169,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 180,
        183 => 183,
        185 => 185,
        186 => 186,
        189 => 189,
        190 => 190,
        191 => 191,
        192 => 192,
        195 => 192,
        193 => 193,
        196 => 193,
        194 => 194,
        197 => 197,
        198 => 198,
    );
// line 245 "src/Parser/TemplateParser.y"
    public function yy_r0(){
    $this->root_buffer->prepend_array($this, $this->template_prefix);
    $this->root_buffer->append_array($this, $this->template_postfix);
    $this->_retvalue = $this->root_buffer->to_smarty_php($this);
    }
// line 252 "src/Parser/TemplateParser.y"
    public function yy_r1(){
         $text = $this->yystack[ $this->yyidx + 0 ]->minor;

         if ((string)$text == '') {
            $this->current_buffer->append_subtree($this, null);
         }

         $this->current_buffer->append_subtree($this, new \Smarty\ParseTree\Text($text, $this->strip));
    }
// line 262 "src/Parser/TemplateParser.y"
    public function yy_r2(){
    $this->strip = true;
    }
// line 266 "src/Parser/TemplateParser.y"
    public function yy_r3(){
    $this->strip = false;
    }
// line 271 "src/Parser/TemplateParser.y"
    public function yy_r4(){
       $this->current_buffer->append_subtree($this, new \Smarty\ParseTree\Text($this->yystack[$this->yyidx + -1]->minor));
    }
// line 276 "src/Parser/TemplateParser.y"
    public function yy_r5(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor.$this->yystack[$this->yyidx + -1]->minor;
    }
// line 279 "src/Parser/TemplateParser.y"
    public function yy_r6(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
// line 283 "src/Parser/TemplateParser.y"
    public function yy_r7(){
        $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;

    }
// line 288 "src/Parser/TemplateParser.y"
    public function yy_r8(){
    $this->_retvalue = '';
    }
// line 292 "src/Parser/TemplateParser.y"
    public function yy_r9(){
     $this->current_buffer->append_subtree($this, $this->mergePrefixCode($this->yystack[$this->yyidx + 0]->minor));
     $this->compiler->has_variable_string = false;
     $this->block_nesting_level = $this->compiler->getTagStackCount();
    }
// line 302 "src/Parser/TemplateParser.y"
    public function yy_r11(){
    $var = trim(substr($this->yystack[$this->yyidx + 0]->minor, $this->compiler->getLdelLength(), -$this->compiler->getRdelLength()), ' $');
    $attributes = [];
    if (preg_match('/^(.*)(\s+nocache)$/', $var, $match)) {
        $attributes[] = 'nocache';
        $var = $match[1];
    }
    $this->compiler->triggerTagNoCache($var);
    $this->_retvalue = $this->compiler->compilePrintExpression('$_smarty_tpl->getValue(\''.$var.'\')', $attributes);
    }
// line 314 "src/Parser/TemplateParser.y"
    public function yy_r12(){
    $tag = trim(substr($this->yystack[$this->yyidx + 0]->minor, $this->compiler->getLdelLength(), -$this->compiler->getRdelLength()));
    if ($tag == 'strip') {
        $this->strip = true;
        $this->_retvalue = null;
    } else {
        if (defined($tag)) {
            if ($this->security) {
               $this->security->isTrustedConstant($tag, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compilePrintExpression($tag);
        } else {
            if (preg_match('/^(.*)(\s+nocache)$/', $tag, $match)) {
                $this->_retvalue = $this->compiler->compileTag($match[1],array('\'nocache\''));
            } else {
                $this->_retvalue = $this->compiler->compileTag($tag,array());
            }
        }
    }
    }
// line 335 "src/Parser/TemplateParser.y"
    public function yy_r13(){
    $j = strrpos($this->yystack[$this->yyidx + 0]->minor,'.');
    if ($this->yystack[$this->yyidx + 0]->minor[$j+1] == 'c') {
        // {$smarty.block.child}
        $this->_retvalue = $this->compiler->compileChildBlock();
    } else {
        // {$smarty.block.parent}
       $this->_retvalue = $this->compiler->compileParentBlock();
     }
    }
// line 346 "src/Parser/TemplateParser.y"
    public function yy_r14(){
    $this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor;
    }
// line 350 "src/Parser/TemplateParser.y"
    public function yy_r15(){
     $this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor;
     }
// line 354 "src/Parser/TemplateParser.y"
    public function yy_r16(){
    $this->_retvalue = $this->compiler->compilePrintExpression($this->yystack[$this->yyidx + 0]->minor[0], $this->yystack[$this->yyidx + 0]->minor[1]);
    }
// line 363 "src/Parser/TemplateParser.y"
    public function yy_r17(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + 0]->minor[0]),array('var'=>'\''.substr($this->yystack[$this->yyidx + -1]->minor,1).'\'')),$this->yystack[$this->yyidx + 0]->minor[1]));
    }
// line 367 "src/Parser/TemplateParser.y"
    public function yy_r18(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + 0]->minor[0]),array('var'=>$this->yystack[$this->yyidx + -1]->minor['var'])),$this->yystack[$this->yyidx + 0]->minor[1]),array('smarty_internal_index'=>$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']));
    }
// line 371 "src/Parser/TemplateParser.y"
    public function yy_r19(){
       $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
// line 375 "src/Parser/TemplateParser.y"
    public function yy_r20(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
    }
// line 390 "src/Parser/TemplateParser.y"
    public function yy_r24(){
        if (defined($this->yystack[$this->yyidx + -1]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[$this->yyidx + -1]->minor, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compilePrintExpression($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
        }
    }
// line 400 "src/Parser/TemplateParser.y"
    public function yy_r25(){
        if (defined($this->yystack[$this->yyidx + 0]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[$this->yyidx + 0]->minor, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compilePrintExpression($this->yystack[$this->yyidx + 0]->minor);
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + 0]->minor,array());
        }
    }
// line 413 "src/Parser/TemplateParser.y"
    public function yy_r26(){
        if (defined($this->yystack[$this->yyidx + -2]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[$this->yyidx + -2]->minor, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compilePrintExpression($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + 0]->minor, array('modifierlist'=>$this->yystack[$this->yyidx + -1]->minor));
        }
    }
// line 425 "src/Parser/TemplateParser.y"
    public function yy_r27(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + 0]->minor,array('object_method'=>$this->yystack[$this->yyidx + -1]->minor));
    }
// line 430 "src/Parser/TemplateParser.y"
    public function yy_r28(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + 0]->minor,array('modifierlist'=>$this->yystack[$this->yyidx + -1]->minor, 'object_method'=>$this->yystack[$this->yyidx + -2]->minor));
    }
// line 435 "src/Parser/TemplateParser.y"
    public function yy_r29(){
    $tag = trim(substr($this->yystack[$this->yyidx + -1]->minor,$this->compiler->getLdelLength())); 
    $this->_retvalue = $this->compiler->compileTag(($tag === 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + 0]->minor));
    }
// line 440 "src/Parser/TemplateParser.y"
    public function yy_r30(){
    $tag = trim(substr($this->yystack[$this->yyidx + -2]->minor,$this->compiler->getLdelLength()));
    $this->_retvalue = $this->compiler->compileTag(($tag === 'else if')? 'elseif' : $tag,$this->yystack[$this->yyidx + 0]->minor,array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));
    }
// line 445 "src/Parser/TemplateParser.y"
    public function yy_r31(){
    $tag = trim(substr($this->yystack[$this->yyidx + -1]->minor,$this->compiler->getLdelLength()));
    $this->_retvalue = $this->compiler->compileTag(($tag === 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + 0]->minor));
    }
// line 456 "src/Parser/TemplateParser.y"
    public function yy_r33(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('start'=>$this->yystack[$this->yyidx + -6]->minor),array('ifexp'=>$this->yystack[$this->yyidx + -4]->minor),array('var'=>$this->yystack[$this->yyidx + -2]->minor),array('step'=>$this->yystack[$this->yyidx + -1]->minor))),1);
    }
// line 460 "src/Parser/TemplateParser.y"
    public function yy_r34(){
    $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 468 "src/Parser/TemplateParser.y"
    public function yy_r36(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('start'=>$this->yystack[$this->yyidx + -3]->minor),array('to'=>$this->yystack[$this->yyidx + -1]->minor))),0);
    }
// line 472 "src/Parser/TemplateParser.y"
    public function yy_r37(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('start'=>$this->yystack[$this->yyidx + -5]->minor),array('to'=>$this->yystack[$this->yyidx + -3]->minor),array('step'=>$this->yystack[$this->yyidx + -1]->minor))),0);
    }
// line 477 "src/Parser/TemplateParser.y"
    public function yy_r38(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('from'=>$this->yystack[$this->yyidx + -3]->minor),array('item'=>$this->yystack[$this->yyidx + -1]->minor))));
    }
// line 481 "src/Parser/TemplateParser.y"
    public function yy_r39(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -1]->minor),array('key'=>$this->yystack[$this->yyidx + -3]->minor))));
    }
// line 484 "src/Parser/TemplateParser.y"
    public function yy_r40(){
    $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + 0]->minor);
    }
// line 489 "src/Parser/TemplateParser.y"
    public function yy_r41(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array(array_merge(array($this->yystack[$this->yyidx + -1]->minor),$this->yystack[$this->yyidx + 0]->minor))));
    }
// line 493 "src/Parser/TemplateParser.y"
    public function yy_r42(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array_merge(array(array_merge(array($this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor)),$this->yystack[$this->yyidx + 0]->minor)));
    }
// line 499 "src/Parser/TemplateParser.y"
    public function yy_r43(){
    $tag = trim(substr($this->yystack[$this->yyidx + 0]->minor, $this->compiler->getLdelLength(), -$this->compiler->getRdelLength()), ' /');
    if ($tag === 'strip') {
        $this->strip = false;
        $this->_retvalue = null;
    } else {
       $this->_retvalue = $this->compiler->compileTag($tag.'close',array());
    }
     }
// line 508 "src/Parser/TemplateParser.y"
    public function yy_r44(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + 0]->minor.'close',array());
    }
// line 512 "src/Parser/TemplateParser.y"
    public function yy_r45(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array(),array('modifier_list'=>$this->yystack[$this->yyidx + 0]->minor));
    }
// line 517 "src/Parser/TemplateParser.y"
    public function yy_r46(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',array(),array('object_method'=>$this->yystack[$this->yyidx + 0]->minor));
    }
// line 521 "src/Parser/TemplateParser.y"
    public function yy_r47(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array(),array('object_method'=>$this->yystack[$this->yyidx + -1]->minor, 'modifier_list'=>$this->yystack[$this->yyidx + 0]->minor));
    }
// line 529 "src/Parser/TemplateParser.y"
    public function yy_r48(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
// line 535 "src/Parser/TemplateParser.y"
    public function yy_r49(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);
    }
// line 540 "src/Parser/TemplateParser.y"
    public function yy_r50(){
    $this->_retvalue = array();
    }
// line 545 "src/Parser/TemplateParser.y"
    public function yy_r51(){
    if (defined($this->yystack[$this->yyidx + 0]->minor)) {
        if ($this->security) {
            $this->security->isTrustedConstant($this->yystack[$this->yyidx + 0]->minor, $this->compiler);
        }
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);
    } else {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'\''.$this->yystack[$this->yyidx + 0]->minor.'\'');
    }
    }
// line 556 "src/Parser/TemplateParser.y"
    public function yy_r52(){
    $this->_retvalue = array(trim($this->yystack[$this->yyidx + -1]->minor," =\n\r\t")=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 564 "src/Parser/TemplateParser.y"
    public function yy_r54(){
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';
    }
// line 576 "src/Parser/TemplateParser.y"
    public function yy_r57(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 589 "src/Parser/TemplateParser.y"
    public function yy_r59(){
    $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor;
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    }
// line 594 "src/Parser/TemplateParser.y"
    public function yy_r60(){
    $this->_retvalue = array('var' => '\''.substr($this->yystack[$this->yyidx + -2]->minor,1).'\'', 'value'=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 601 "src/Parser/TemplateParser.y"
    public function yy_r62(){
    $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 605 "src/Parser/TemplateParser.y"
    public function yy_r63(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
// line 630 "src/Parser/TemplateParser.y"
    public function yy_r67(){
	$this->_retvalue = '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->preIncDec(\'' . $this->yystack[$this->yyidx + -1]->minor . '\')';
    }
// line 635 "src/Parser/TemplateParser.y"
    public function yy_r68(){
	$this->_retvalue = '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + -1]->minor,1) .'\')->postIncDec(\'' . $this->yystack[$this->yyidx + 0]->minor . '\')';
    }
// line 640 "src/Parser/TemplateParser.y"
    public function yy_r69(){
    $this->_retvalue = '$_smarty_tpl->getStreamVariable(\''.substr($this->yystack[$this->yyidx + -2]->minor,1).'://' . $this->yystack[$this->yyidx + 0]->minor . '\')';
    }
// line 645 "src/Parser/TemplateParser.y"
    public function yy_r70(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;
    }
// line 655 "src/Parser/TemplateParser.y"
    public function yy_r72(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor['pre']. $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor['op'].$this->yystack[$this->yyidx + 0]->minor .')';
    }
// line 659 "src/Parser/TemplateParser.y"
    public function yy_r73(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 663 "src/Parser/TemplateParser.y"
    public function yy_r74(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor . $this->yystack[$this->yyidx + -1]->minor . ')';
    }
// line 667 "src/Parser/TemplateParser.y"
    public function yy_r75(){
    static $isin = [
        'isin' => 'in_array(',
        'isnotin' => '!in_array(',
    ];
   $op = strtolower(str_replace(' ', '', $this->yystack[$this->yyidx + 0]->minor));
   $this->_retvalue = $isin[$op];
    }
// line 676 "src/Parser/TemplateParser.y"
    public function yy_r76(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';
    }
// line 680 "src/Parser/TemplateParser.y"
    public function yy_r77(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';
    }
// line 685 "src/Parser/TemplateParser.y"
    public function yy_r78(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor.' ?? '.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 692 "src/Parser/TemplateParser.y"
    public function yy_r79(){
    $this->compiler->triggerTagNoCache(substr($this->yystack[$this->yyidx + -2]->minor,1));
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor.' ? $_smarty_tpl->getValue(\''.substr($this->yystack[$this->yyidx + -2]->minor,1).'\') : '.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 697 "src/Parser/TemplateParser.y"
    public function yy_r80(){
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 706 "src/Parser/TemplateParser.y"
    public function yy_r82(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor.' ?: '.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 716 "src/Parser/TemplateParser.y"
    public function yy_r84(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 721 "src/Parser/TemplateParser.y"
    public function yy_r85(){
    $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 742 "src/Parser/TemplateParser.y"
    public function yy_r90(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 746 "src/Parser/TemplateParser.y"
    public function yy_r91(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';
    }
// line 750 "src/Parser/TemplateParser.y"
    public function yy_r92(){
    $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 755 "src/Parser/TemplateParser.y"
    public function yy_r93(){
    if (defined($this->yystack[$this->yyidx + 0]->minor)) {
        if ($this->security) {
             $this->security->isTrustedConstant($this->yystack[$this->yyidx + 0]->minor, $this->compiler);
        }
        $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';
    }
    }
// line 772 "src/Parser/TemplateParser.y"
    public function yy_r95(){
    $this->_retvalue = '('. $this->yystack[$this->yyidx + -1]->minor .')';
    }
// line 776 "src/Parser/TemplateParser.y"
    public function yy_r96(){
      $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 794 "src/Parser/TemplateParser.y"
    public function yy_r100(){
    if ($this->security && $this->security->static_classes !== array()) {
        $this->compiler->trigger_template_error('dynamic static class not allowed by security setting');
    }
    $prefixVar = $this->compiler->getNewPrefixVariable();
    if ($this->yystack[$this->yyidx + -2]->minor['var'] === '\'smarty\'') {
        $this->compiler->appendPrefixCode("<?php {$prefixVar} = ". (new \Smarty\Compile\SpecialVariableCompiler())->compile(array(),$this->compiler,$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).';?>');
     } else {
        $this->compiler->triggerTagNoCache($this->yystack[$this->yyidx + -2]->minor['var']);
        $this->compiler->appendPrefixCode("<?php  {$prefixVar} = \$_smarty_tpl->getValue(" . $this->yystack[$this->yyidx + -2]->minor['var'] . ')'.$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].';?>');
    }
    $this->_retvalue = $prefixVar .'::'.$this->yystack[$this->yyidx + 0]->minor[0].$this->yystack[$this->yyidx + 0]->minor[1];
    }
// line 809 "src/Parser/TemplateParser.y"
    public function yy_r101(){
    $prefixVar = $this->compiler->getNewPrefixVariable();
    $tmp = $this->compiler->appendCode('<?php ob_start();?>', (string) $this->yystack[$this->yyidx + 0]->minor);
    $this->compiler->appendPrefixCode($this->compiler->appendCode($tmp, "<?php {$prefixVar} = ob_get_clean();?>"));
    $this->_retvalue = $prefixVar;
    }
// line 816 "src/Parser/TemplateParser.y"
    public function yy_r102(){
    $this->_retvalue = $this->compiler->compileModifier($this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
// line 829 "src/Parser/TemplateParser.y"
    public function yy_r105(){
    if (!in_array(strtolower($this->yystack[$this->yyidx + -2]->minor), array('self', 'parent')) && (!$this->security || $this->security->isTrustedStaticClassAccess($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->compiler))) {
        if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
            $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor[0].$this->yystack[$this->yyidx + 0]->minor[1];
        } else {
            $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor[0].$this->yystack[$this->yyidx + 0]->minor[1];
        } 
    } else {
        $this->compiler->trigger_template_error ('static class \''.$this->yystack[$this->yyidx + -2]->minor.'\' is undefined or not allowed by security setting');
    }
    }
// line 848 "src/Parser/TemplateParser.y"
    public function yy_r107(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
        }
// line 856 "src/Parser/TemplateParser.y"
    public function yy_r108(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array($this->yystack[$this->yyidx + 0]->minor));
    }
// line 883 "src/Parser/TemplateParser.y"
    public function yy_r113(){
   $this->compiler->triggerTagNoCache(substr($this->yystack[$this->yyidx + 0]->minor,1));
   $this->_retvalue = array('$_smarty_tpl->hasVariable(\''.substr($this->yystack[$this->yyidx + 0]->minor,1).'\')','$_smarty_tpl->getValue(\''.substr($this->yystack[$this->yyidx + 0]->minor,1).'\')');
    }
// line 887 "src/Parser/TemplateParser.y"
    public function yy_r114(){
    if ($this->yystack[$this->yyidx + 0]->minor['var'] === '\'smarty\'') {
        $smarty_var = (new \Smarty\Compile\SpecialVariableCompiler())->compile(array(),$this->compiler,$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
        $this->_retvalue = array('true', $smarty_var);
    } else {
        // used for array reset,next,prev,end,current 
        $this->last_variable = $this->yystack[$this->yyidx + 0]->minor['var'];
        $this->last_index = $this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
        $this->compiler->triggerTagNoCache($this->yystack[$this->yyidx + 0]->minor['var']);
        $this->_retvalue = array('true', '$_smarty_tpl->getValue(' . $this->yystack[$this->yyidx + 0]->minor['var'] . ')'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
    }
    }
// line 901 "src/Parser/TemplateParser.y"
    public function yy_r115(){
    $this->_retvalue = array('true', '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor);
    }
// line 906 "src/Parser/TemplateParser.y"
    public function yy_r116(){
    $this->_retvalue = array('true', $this->yystack[$this->yyidx + 0]->minor);
    }
// line 911 "src/Parser/TemplateParser.y"
    public function yy_r117(){
    $this->_retvalue = $this->compiler->compileConfigVariable('\'' . $this->yystack[$this->yyidx + -1]->minor . '\'');
    }
// line 915 "src/Parser/TemplateParser.y"
    public function yy_r118(){
    $this->_retvalue = '(is_array($tmp = ' . $this->compiler->compileConfigVariable('\'' . $this->yystack[$this->yyidx + -2]->minor . '\'') . ') ? $tmp'.$this->yystack[$this->yyidx + 0]->minor.' :null)';
    }
// line 919 "src/Parser/TemplateParser.y"
    public function yy_r119(){
    $this->_retvalue = $this->compiler->compileConfigVariable($this->yystack[$this->yyidx + -1]->minor);
    }
// line 923 "src/Parser/TemplateParser.y"
    public function yy_r120(){
    $this->_retvalue = '(is_array($tmp = ' . $this->compiler->compileConfigVariable($this->yystack[$this->yyidx + -2]->minor) . ') ? $tmp'.$this->yystack[$this->yyidx + 0]->minor.' : null)';
    }
// line 927 "src/Parser/TemplateParser.y"
    public function yy_r121(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor[1];
    }
// line 935 "src/Parser/TemplateParser.y"
    public function yy_r123(){
    $this->_retvalue = array('var'=>'\''.substr($this->yystack[$this->yyidx + -1]->minor,1).'\'', 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 938 "src/Parser/TemplateParser.y"
    public function yy_r124(){
    $this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 951 "src/Parser/TemplateParser.y"
    public function yy_r126(){
    return;
    }
// line 957 "src/Parser/TemplateParser.y"
    public function yy_r127(){
    $this->compiler->triggerTagNoCache(substr($this->yystack[$this->yyidx + 0]->minor,1));
    $this->_retvalue = '[$_smarty_tpl->getValue(\''.substr($this->yystack[$this->yyidx + 0]->minor,1).'\')]';
    }
// line 961 "src/Parser/TemplateParser.y"
    public function yy_r128(){
    $this->compiler->triggerTagNoCache($this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue = '[$_smarty_tpl->getValue(' . $this->yystack[$this->yyidx + 0]->minor . ')]';
    }
// line 966 "src/Parser/TemplateParser.y"
    public function yy_r129(){
    $this->compiler->triggerTagNoCache($this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue = '[$_smarty_tpl->getValue(' . $this->yystack[$this->yyidx + -2]->minor . ')->'.$this->yystack[$this->yyidx + 0]->minor.']';
    }
// line 971 "src/Parser/TemplateParser.y"
    public function yy_r130(){
    $this->_retvalue = '[\''. $this->yystack[$this->yyidx + 0]->minor .'\']';
    }
// line 975 "src/Parser/TemplateParser.y"
    public function yy_r131(){
    $this->_retvalue = '['. $this->yystack[$this->yyidx + 0]->minor .']';
    }
// line 980 "src/Parser/TemplateParser.y"
    public function yy_r132(){
    $this->_retvalue = '['. $this->yystack[$this->yyidx + -1]->minor .']';
    }
// line 985 "src/Parser/TemplateParser.y"
    public function yy_r133(){
    $this->_retvalue = '['.(new \Smarty\Compile\SpecialVariableCompiler())->compile(array(),$this->compiler,'[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';
    }
// line 989 "src/Parser/TemplateParser.y"
    public function yy_r134(){
    $this->_retvalue = '['.(new \Smarty\Compile\SpecialVariableCompiler())->compile(array(),$this->compiler,'[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';
    }
// line 992 "src/Parser/TemplateParser.y"
    public function yy_r135(){
    $this->_retvalue = '['.$this->yystack[$this->yyidx + -1]->minor.']';
    }
// line 998 "src/Parser/TemplateParser.y"
    public function yy_r137(){
    $this->compiler->triggerTagNoCache(substr($this->yystack[$this->yyidx + -1]->minor,1));
    $this->_retvalue = '[$_smarty_tpl->getValue(\''.substr($this->yystack[$this->yyidx + -1]->minor,1).'\')]';
    }
// line 1015 "src/Parser/TemplateParser.y"
    public function yy_r141(){
    $this->_retvalue = '[]';
    }
// line 1025 "src/Parser/TemplateParser.y"
    public function yy_r142(){
    $this->_retvalue = '\''.substr($this->yystack[$this->yyidx + 0]->minor,1).'\'';
    }
// line 1029 "src/Parser/TemplateParser.y"
    public function yy_r143(){
    $this->_retvalue = '\'\'';
    }
// line 1034 "src/Parser/TemplateParser.y"
    public function yy_r144(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1042 "src/Parser/TemplateParser.y"
    public function yy_r146(){
    $var = trim(substr($this->yystack[$this->yyidx + 0]->minor, $this->compiler->getLdelLength(), -$this->compiler->getRdelLength()), ' $');
    $this->compiler->triggerTagNoCache($var);
    $this->_retvalue = '$_smarty_tpl->getValue(\''.$var.'\')';
    }
// line 1049 "src/Parser/TemplateParser.y"
    public function yy_r147(){
    $this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
// line 1056 "src/Parser/TemplateParser.y"
    public function yy_r148(){
    if ($this->yystack[$this->yyidx + -1]->minor['var'] === '\'smarty\'') {
        $this->_retvalue = (new \Smarty\Compile\SpecialVariableCompiler())->compile(array(),$this->compiler,$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->compiler->triggerTagNoCache($this->yystack[$this->yyidx + -1]->minor['var']);
        $this->_retvalue = '$_smarty_tpl->getValue(' . $this->yystack[$this->yyidx + -1]->minor['var'] . ')'.$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor;
    }
    }
// line 1066 "src/Parser/TemplateParser.y"
    public function yy_r149(){
    $this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;
    }
// line 1071 "src/Parser/TemplateParser.y"
    public function yy_r150(){
    $this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1076 "src/Parser/TemplateParser.y"
    public function yy_r151(){
    if ($this->security && substr($this->yystack[$this->yyidx + -1]->minor,0,1) === '_') {
        $this->compiler->trigger_template_error (self::ERR1);
    }
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1083 "src/Parser/TemplateParser.y"
    public function yy_r152(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::ERR2);
    }
    $this->compiler->triggerTagNoCache($this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue = '->{$_smarty_tpl->getValue(' . $this->yystack[$this->yyidx + -1]->minor . ')'.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
// line 1091 "src/Parser/TemplateParser.y"
    public function yy_r153(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::ERR2);
    }
    $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
// line 1098 "src/Parser/TemplateParser.y"
    public function yy_r154(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::ERR2);
    }
    $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
// line 1106 "src/Parser/TemplateParser.y"
    public function yy_r155(){
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1114 "src/Parser/TemplateParser.y"
    public function yy_r156(){

    if ($this->yystack[$this->yyidx + -3]->minor == 'isset') {
        $this->_retvalue = '(true';
        if (count($this->yystack[$this->yyidx + -1]->minor) == 0) {
            throw new CompilerException("Invalid number of arguments for isset. isset expects at least one parameter.");
        }
        foreach ($this->yystack[$this->yyidx + -1]->minor as $value) {
            if (is_array($value)) {
                $this->_retvalue .= ' && (' . $value[0] . ' && null !== (' . $value[1] . ' ?? null))';
            } else {
                $this->_retvalue .= ' && (' . $value . ' !== null)';
            }
        }
        $this->_retvalue .= ')';
    } elseif ($this->yystack[$this->yyidx + -3]->minor == 'empty') {
        if (count($this->yystack[$this->yyidx + -1]->minor) != 1) {
            throw new CompilerException("Invalid number of arguments for empty. empty expects at exactly one parameter.");
        }
        if (is_array($this->yystack[$this->yyidx + -1]->minor[0])) {
            $this->_retvalue .= '( !' . $this->yystack[$this->yyidx + -1]->minor[0][0] . ' || empty(' . $this->yystack[$this->yyidx + -1]->minor[0][1] . '))';
        } else {
            $this->_retvalue = 'false == ' . $this->yystack[$this->yyidx + -1]->minor[0];
        }
    } else {
        $p = array();
        foreach ($this->yystack[$this->yyidx + -1]->minor as $value) {
            if (is_array($value)) {
                $p[] = $value[1];
            } else {
                $p[] = $value;
            }
        }
        $this->_retvalue = $this->compiler->compileModifierInExpression($this->yystack[$this->yyidx + -3]->minor, $p);
    }
    }
// line 1155 "src/Parser/TemplateParser.y"
    public function yy_r157(){
    if ($this->security && substr($this->yystack[$this->yyidx + -3]->minor,0,1) === '_') {
        $this->compiler->trigger_template_error (self::ERR1);
    }
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . '('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
    }
// line 1162 "src/Parser/TemplateParser.y"
    public function yy_r158(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::ERR2);
    }
    $prefixVar = $this->compiler->getNewPrefixVariable();
    $this->compiler->triggerTagNoCache(substr($this->yystack[$this->yyidx + -3]->minor,1));
    $this->compiler->appendPrefixCode("<?php {$prefixVar} = \$_smarty_tpl->getValue('".substr($this->yystack[$this->yyidx + -3]->minor,1).'\')'.';?>');
    $this->_retvalue = $prefixVar .'('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
    }
// line 1191 "src/Parser/TemplateParser.y"
    public function yy_r162(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor)));
    }
// line 1195 "src/Parser/TemplateParser.y"
    public function yy_r163(){
    $this->_retvalue = array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor));
    }
// line 1203 "src/Parser/TemplateParser.y"
    public function yy_r165(){
    $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor);
    }
// line 1211 "src/Parser/TemplateParser.y"
    public function yy_r166(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
    }
// line 1224 "src/Parser/TemplateParser.y"
    public function yy_r169(){
    $this->_retvalue = array(trim($this->yystack[$this->yyidx + -1]->minor).$this->yystack[$this->yyidx + 0]->minor);
    }
// line 1233 "src/Parser/TemplateParser.y"
    public function yy_r171(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor, '', 'method');
    }
// line 1238 "src/Parser/TemplateParser.y"
    public function yy_r172(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor, 'method');
    }
// line 1243 "src/Parser/TemplateParser.y"
    public function yy_r173(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor, '');
    }
// line 1248 "src/Parser/TemplateParser.y"
    public function yy_r174(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor, 'property');
    }
// line 1253 "src/Parser/TemplateParser.y"
    public function yy_r175(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor, 'property');
    }
// line 1259 "src/Parser/TemplateParser.y"
    public function yy_r176(){
    $this->_retvalue = ' '. trim($this->yystack[$this->yyidx + 0]->minor) . ' ';
    }
// line 1263 "src/Parser/TemplateParser.y"
    public function yy_r177(){
    static $lops = array(
        'eq' => ' == ',
        'ne' => ' != ',
        'neq' => ' != ',
        'gt' => ' > ',
        'ge' => ' >= ',
        'gte' => ' >= ',
        'lt' =>  ' < ',
        'le' =>  ' <= ',
        'lte' => ' <= ',
        'mod' =>  ' % ',
        'and' => ' && ',
        'or' => ' || ',
        'xor' => ' xor ',
         );
    $op = strtolower(preg_replace('/\s*/', '', $this->yystack[$this->yyidx + 0]->minor));
    $this->_retvalue = $lops[$op];
    }
// line 1282 "src/Parser/TemplateParser.y"
    public function yy_r178(){
     static $tlops = array(
         'isdivby' => array('op' => ' % ', 'pre' => '!('),
         'isnotdivby' => array('op' => ' % ', 'pre' => '('),
         'isevenby' => array('op' => ' / ', 'pre' => '!(1 & '),
         'isnotevenby' => array('op' => ' / ', 'pre' => '(1 & '),
         'isoddby' => array('op' => ' / ', 'pre' => '(1 & '),
         'isnotoddby' => array('op' => ' / ', 'pre' => '!(1 & '),
         );
     $op = strtolower(preg_replace('/\s*/', '', $this->yystack[$this->yyidx + 0]->minor));
     $this->_retvalue = $tlops[$op];
     }
// line 1295 "src/Parser/TemplateParser.y"
    public function yy_r179(){
        static $scond = array (
            'iseven' => '!(1 & ',
            'isnoteven' => '(1 & ',
            'isodd' => '(1 & ',
            'isnotodd' => '!(1 & ',
        );
   $op = strtolower(str_replace(' ', '', $this->yystack[$this->yyidx + 0]->minor));
   $this->_retvalue = $scond[$op];
    }
// line 1309 "src/Parser/TemplateParser.y"
    public function yy_r180(){
    $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
// line 1320 "src/Parser/TemplateParser.y"
    public function yy_r183(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1328 "src/Parser/TemplateParser.y"
    public function yy_r185(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1332 "src/Parser/TemplateParser.y"
    public function yy_r186(){ 
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1348 "src/Parser/TemplateParser.y"
    public function yy_r189(){
    $this->compiler->leaveDoubleQuote();
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php($this);
    }
// line 1354 "src/Parser/TemplateParser.y"
    public function yy_r190(){
    $this->yystack[$this->yyidx + -1]->minor->append_subtree($this, $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
// line 1359 "src/Parser/TemplateParser.y"
    public function yy_r191(){
    $this->_retvalue = new Dq($this, $this->yystack[$this->yyidx + 0]->minor);
    }
// line 1363 "src/Parser/TemplateParser.y"
    public function yy_r192(){
    $this->_retvalue = new Code('(string)'.$this->yystack[$this->yyidx + -1]->minor);
    }
// line 1367 "src/Parser/TemplateParser.y"
    public function yy_r193(){
    $this->_retvalue = new Code('(string)('.$this->yystack[$this->yyidx + -1]->minor.')');
    }
// line 1371 "src/Parser/TemplateParser.y"
    public function yy_r194(){
    $this->_retvalue = new Code('(string)$_smarty_tpl->getValue(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')');
    }
// line 1383 "src/Parser/TemplateParser.y"
    public function yy_r197(){
    $this->_retvalue = new Tag($this, $this->yystack[$this->yyidx + 0]->minor);
    }
// line 1387 "src/Parser/TemplateParser.y"
    public function yy_r198(){
    $this->_retvalue = new DqContent($this->yystack[$this->yyidx + 0]->minor);
    }

    private $_retvalue;

    public function yy_reduce($yyruleno)
    {
        if ($this->yyTraceFILE && $yyruleno >= 0
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf($this->yyTraceFILE, "%sReduce (%d) [%s].\n",
                $this->yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (isset(self::$yyReduceMap[$yyruleno])) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno][0];
        $yysize = self::$yyRuleInfo[$yyruleno][1];
        $this->yyidx -= $yysize;
        for ($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!$this->yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = (object) ['stateno' => null, 'major' => null, 'minor' => null];
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact === self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    public function yy_parse_failed()
    {
        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sFail!\n", $this->yyTracePrompt);
        } while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    public function yy_syntax_error($yymajor, $TOKEN)
    {
// line 225 "src/Parser/TemplateParser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
    }

    public function yy_accept()
    {
        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sAccept!\n", $this->yyTracePrompt);
        } while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
// line 218 "src/Parser/TemplateParser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    }

    public function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = (object) ['stateno' => null, 'major' => null, 'minor' => null];
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            $this->yystack[] = $x;
        }
        $yyendofinput = ($yymajor==0);

        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sInput %s\n",
                $this->yyTracePrompt, $this->yyTokenName[$yymajor]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact === self::YY_ERROR_ACTION) {
                if ($this->yyTraceFILE) {
                    fprintf($this->yyTraceFILE, "%sSyntax Error!\n",
                        $this->yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx === self::YYERRORSYMBOL || $yyerrorhit) {
                        if ($this->yyTraceFILE) {
                            fprintf($this->yyTraceFILE, "%sDiscard input token %s\n",
                                $this->yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx !== self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx !== self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        } while ($yymajor !== self::YYNOCODE && $this->yyidx >= 0);
    }
}

